/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.catalina.sso;

import java.io.IOException;
import java.security.Principal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.catalina.sso.LocalSSOContext;
import org.wildfly.clustering.web.catalina.sso.ManagerRegistry;
import org.wildfly.clustering.web.catalina.sso.SingleSignOnEntryFacade;
import org.wildfly.clustering.web.sso.AuthenticationType;
import org.wildfly.clustering.web.sso.Credentials;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.WebApplication;

public class SingleSignOnFacade
extends SingleSignOn
implements ManagerRegistry,
LifecycleListener {
    private final ConcurrentMap<WebApplication, Manager> managers = new ConcurrentHashMap<WebApplication, Manager>();
    private final SSOManager<LocalSSOContext> manager;

    public SingleSignOnFacade(SSOManager<LocalSSOContext> manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Batcher batcher = this.manager.getBatcher();
        boolean started = batcher.startBatch();
        boolean successful = false;
        try {
            super.invoke(request, response);
            successful = true;
        }
        finally {
            if (started) {
                batcher.endBatch(successful);
            }
        }
    }

    @Override
    public Manager getManager(WebApplication application) {
        return (Manager)this.managers.get(application);
    }

    @Override
    public WebApplication getApplication(Manager manager) {
        Context context = (Context)manager.getContainer();
        Host host = (Host)context.getParent();
        return new WebApplication(context.getPath(), host.getName());
    }

    private WebApplication getApplication(Session session) {
        return this.getApplication(session.getManager());
    }

    protected void deregister(String ssoId, Session session) {
        this.removeSession(ssoId, session);
    }

    protected SingleSignOnEntry lookup(String ssoId) {
        SSO sso = this.manager.findSSO(ssoId);
        return sso != null ? new SingleSignOnEntryFacade((SSO<LocalSSOContext>)sso, this) : null;
    }

    protected void removeSession(String ssoId, Session session) {
        SSO sso = this.manager.findSSO(ssoId);
        if (sso != null) {
            sso.getSessions().removeSession(this.getApplication(session));
            if (sso.getSessions().getApplications().isEmpty()) {
                sso.invalidate();
            }
        }
    }

    public void associate(String ssoId, Session session) {
        SSO sso = this.manager.findSSO(ssoId);
        Manager manager = session.getManager();
        WebApplication application = this.getApplication(manager);
        if (sso != null) {
            sso.getSessions().addSession(application, session.getId());
        }
        if (this.managers.putIfAbsent(this.getApplication(session), session.getManager()) == null) {
            ((Lifecycle)manager).addLifecycleListener((LifecycleListener)this);
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source;
        Manager manager;
        String type = event.getType();
        if ("stop".equals(type) && this.managers.remove(this.getApplication(manager = (Manager)(source = event.getLifecycle()))) != null) {
            source.removeLifecycleListener((LifecycleListener)this);
        }
    }

    public void deregister(String ssoId) {
        SSO sso = this.manager.findSSO(ssoId);
        if (sso != null) {
            sso.invalidate();
        }
    }

    public void register(String ssoId, Principal principal, String authType, String username, String password) {
        SSO sso = this.manager.createSSO(ssoId);
        ((LocalSSOContext)sso.getLocalContext()).setPrincipal(principal);
        Credentials credentials = sso.getCredentials();
        credentials.setAuthenticationType(AuthenticationType.valueOf((String)authType));
        credentials.setUser(username);
        credentials.setPassword(password);
    }

    public void update(String ssoId, Principal principal, String authType, String username, String password) {
        SSO sso = this.manager.findSSO(ssoId);
        if (sso != null) {
            ((LocalSSOContext)sso.getLocalContext()).setPrincipal(principal);
            Credentials credentials = sso.getCredentials();
            credentials.setAuthenticationType(AuthenticationType.valueOf((String)authType));
            credentials.setUser(username);
            credentials.setPassword(password);
        }
    }
}

