/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.function.Function;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.msc.service.ServiceName;

public enum SingletonRuntimeResourceRegistration implements ResourceRegistration
{
    DEPLOYMENT("deployment", name -> name.getParent().getSimpleName()),
    SERVICE("service", ServiceName::getCanonicalName);

    private final PathElement path;
    private final Function<ServiceName, String> resolver;

    private SingletonRuntimeResourceRegistration(String key, Function<ServiceName, String> resolver) {
        this.path = PathElement.pathElement((String)key);
        this.resolver = resolver;
    }

    public PathElement getPathElement() {
        return this.path;
    }

    PathElement pathElement(ServiceName name) {
        return PathElement.pathElement((String)this.path.getKey(), (String)this.resolver.apply(name));
    }
}

