/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.function.SerializableFunction;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.infinispan.retry.RetryingInvoker;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.GroupListener;
import org.wildfly.clustering.group.Membership;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.provider.GetLocalServicesCommand;
import org.wildfly.clustering.server.provider.SimpleServiceProviderRegistration;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(sync=false)
public class CacheServiceProviderRegistry<T>
implements ServiceProviderRegistry<T>,
GroupListener,
AutoCloseable {
    final Batcher<? extends Batch> batcher;
    private final ConcurrentMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>> listeners = new ConcurrentHashMap<T, Map.Entry<ServiceProviderRegistration.Listener, ExecutorService>>();
    private final Cache<T, Set<Address>> cache;
    private final org.wildfly.clustering.server.group.Group<Address> group;
    private final Registration groupRegistration;
    private final CommandDispatcher<Set<T>> dispatcher;
    private final Invoker invoker;

    private static ThreadFactory createThreadFactory(Class<?> targetClass) {
        PrivilegedAction<ThreadFactory> action = () -> new ClassLoaderThreadFactory((ThreadFactory)new JBossThreadFactory(new ThreadGroup(targetClass.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null), targetClass.getClassLoader());
        return (ThreadFactory)WildFlySecurityManager.doUnchecked(action);
    }

    public CacheServiceProviderRegistry(CacheServiceProviderRegistryConfiguration<T> config) {
        this.group = config.getGroup();
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.dispatcher = config.getCommandDispatcherFactory().createCommandDispatcher(config.getId(), this.listeners.keySet());
        this.cache.addListener((Object)this);
        this.groupRegistration = this.group.register(this);
        this.invoker = new RetryingInvoker(this.cache);
    }

    @Override
    public void close() {
        this.groupRegistration.close();
        this.cache.removeListener((Object)this);
        this.dispatcher.close();
        for (Map.Entry entry : this.listeners.values()) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (executor == null) continue;
            PrivilegedAction<List> action = () -> executor.shutdownNow();
            WildFlySecurityManager.doUnchecked(action);
        }
        this.listeners.clear();
    }

    public Group getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T> register(T service) {
        return this.register(service, null);
    }

    public ServiceProviderRegistration<T> register(final T service, ServiceProviderRegistration.Listener listener) {
        AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object> newEntry = new AbstractMap.SimpleEntry<ServiceProviderRegistration.Listener, Object>(listener, null);
        Map.Entry entry = this.listeners.computeIfAbsent(service, key -> {
            if (listener != null) {
                newEntry.setValue(Executors.newSingleThreadExecutor(CacheServiceProviderRegistry.createThreadFactory(listener.getClass())));
            }
            return newEntry;
        });
        if (entry != newEntry) {
            throw new IllegalArgumentException(service.toString());
        }
        ExceptionRunnable<CacheException> registerAction = new ExceptionRunnable<CacheException>(){

            public void run() throws CacheException {
                CacheServiceProviderRegistry.this.registerLocal(service);
            }
        };
        this.invoker.invoke((ExceptionRunnable)registerAction);
        return new SimpleServiceProviderRegistration<T>(service, this, () -> {
            Address localAddress = (Address)this.group.getAddress(this.group.getLocalMember());
            try (Batch batch = this.batcher.createBatch();){
                Set addresses = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get(service);
                if (addresses != null && addresses.remove(localAddress)) {
                    AdvancedCache cache = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                    if (addresses.isEmpty()) {
                        cache.remove(service);
                    } else {
                        cache.replace(service, (Object)addresses);
                    }
                }
            }
            finally {
                ExecutorService executor;
                Map.Entry oldEntry = (Map.Entry)this.listeners.remove(service);
                if (oldEntry != null && (executor = (ExecutorService)oldEntry.getValue()) != null) {
                    PrivilegedAction<List> action = () -> executor.shutdownNow();
                    WildFlySecurityManager.doUnchecked(action);
                    try {
                        executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    void registerLocal(T service) {
        try (Batch batch = this.batcher.createBatch();){
            this.register((Address)this.group.getAddress(this.group.getLocalMember()), service);
        }
    }

    void register(Address address, T service) {
        Set addresses = (Set)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS, Flag.FORCE_WRITE_LOCK}).computeIfAbsent(service, (SerializableFunction & Serializable)key -> new CopyOnWriteArraySet<Address>(Collections.singleton(address)));
        if (addresses.add(address)) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(service, (Object)addresses);
        }
    }

    public Set<Node> getProviders(T service) {
        Set addresses = (Set)this.cache.get(service);
        if (addresses == null) {
            return Collections.emptySet();
        }
        TreeSet<Node> members = new TreeSet<Node>();
        for (Address address : addresses) {
            members.add(this.group.createNode(address));
        }
        return Collections.unmodifiableSet(members);
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    public void membershipChanged(Membership previousMembership, Membership membership, boolean merged) {
        if (membership.isCoordinator()) {
            HashSet previousMembers = new HashSet(previousMembership.getMembers());
            HashSet members = new HashSet(membership.getMembers());
            ArrayList<Object> leftMembers = new ArrayList<Object>(previousMembers.size());
            for (Object previousMember : previousMembers) {
                if (members.contains(previousMember)) continue;
                leftMembers.add(this.group.getAddress((Node)previousMember));
            }
            ArrayList<Object> joinedMembers = new ArrayList<Object>(members.size());
            for (Node member : members) {
                if (previousMembers.contains(member)) continue;
                joinedMembers.add(this.group.getAddress(member));
            }
            if (!leftMembers.isEmpty()) {
                Batch batch = this.batcher.createBatch();
                Object object = null;
                try (CloseableIterator closeableIterator = this.cache.entrySet().iterator();){
                    while (closeableIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)closeableIterator.next();
                        Set addresses = (Set)entry.getValue();
                        if (!addresses.removeAll(leftMembers)) continue;
                        entry.setValue(addresses);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (batch != null) {
                        if (object != null) {
                            try {
                                batch.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            batch.close();
                        }
                    }
                }
            }
            if (merged) {
                GetLocalServicesCommand command = new GetLocalServicesCommand();
                for (final Address address : joinedMembers) {
                    BiConsumer completionHandler = new BiConsumer<Collection<T>, Throwable>(){

                        @Override
                        public void accept(Collection<T> services, Throwable exception) {
                            if (services != null) {
                                try (Batch batch = CacheServiceProviderRegistry.this.batcher.createBatch();){
                                    for (Object service : services) {
                                        CacheServiceProviderRegistry.this.register(address, service);
                                    }
                                }
                            } else if (exception != null) {
                                ClusteringServerLogger.ROOT_LOGGER.warn(exception.getLocalizedMessage(), exception);
                            }
                        }
                    };
                    try {
                        this.dispatcher.executeOnMember(command, this.group.createNode(address)).whenComplete(completionHandler);
                    }
                    catch (CommandDispatcherException e) {
                        ClusteringServerLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void modified(CacheEntryEvent<T, Set<Address>> event) {
        ServiceProviderRegistration.Listener listener;
        if (event.isPre()) {
            return;
        }
        Map.Entry entry = (Map.Entry)this.listeners.get(event.getKey());
        if (entry != null && (listener = (ServiceProviderRegistration.Listener)entry.getKey()) != null) {
            ExecutorService executor = (ExecutorService)entry.getValue();
            TreeSet<Node> members = new TreeSet<Node>();
            for (Address address : (Set)event.getValue()) {
                members.add(this.group.createNode(address));
            }
            try {
                executor.submit(() -> {
                    try {
                        listener.providersChanged(members);
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.serviceProviderRegistrationListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName(), this.cache.getName(), members);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }
}

