/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.wildfly.clustering.ee.cache.function.CollectionFunction;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class AddressSetFunctionMarshaller<F extends CollectionFunction<Address, Set<Address>>>
implements ProtoStreamMarshaller<F> {
    private static final int ELEMENT_INDEX = 1;
    private final Class<? extends F> targetClass;
    private final Function<Collection<Address>, F> factory;

    public AddressSetFunctionMarshaller(Class<? extends F> targetClass, Function<Collection<Address>, F> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public Class<? extends F> getJavaClass() {
        return this.targetClass;
    }

    public F readFrom(ProtoStreamReader reader) throws IOException {
        LinkedList<Address> operand = new LinkedList<Address>();
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    operand.add((Address)reader.readObject(JGroupsAddress.class));
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return (F)((CollectionFunction)this.factory.apply(operand.isEmpty() ? Collections.singleton(LocalModeAddress.INSTANCE) : operand));
    }

    public void writeTo(ProtoStreamWriter writer, F function) throws IOException {
        Collection operand = (Collection)function.getOperand();
        if (operand.size() == 1 && ((Address)operand.iterator().next()).equals(LocalModeAddress.INSTANCE)) {
            return;
        }
        for (Address value : (Collection)function.getOperand()) {
            writer.writeObject(1, (Object)value);
        }
    }
}

