/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.marshalling.VersionedMarshallingConfiguration;

public class SimpleMarshallingContext
implements MarshallingContext {
    private final MarshallerFactory factory;
    private final VersionedMarshallingConfiguration configuration;
    private final WeakReference<ClassLoader> loader;

    public SimpleMarshallingContext(MarshallerFactory factory, VersionedMarshallingConfiguration configuration, ClassLoader loader) {
        this.factory = factory;
        this.configuration = configuration;
        this.loader = new WeakReference<ClassLoader>(loader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.loader.get();
    }

    @Override
    public int getCurrentVersion() {
        return this.configuration.getCurrentMarshallingVersion();
    }

    @Override
    public Unmarshaller createUnmarshaller(int version) throws IOException {
        return this.factory.createUnmarshaller(this.getMarshallingConfiguration(version));
    }

    @Override
    public Marshaller createMarshaller(int version) throws IOException {
        return this.factory.createMarshaller(this.getMarshallingConfiguration(version));
    }

    private MarshallingConfiguration getMarshallingConfiguration(int version) {
        return this.configuration.getMarshallingConfiguration(version);
    }
}

