/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.ClassLoaderThreadFactory;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.SingletonProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolFactory;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.TimerFactory;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.jgroups.protocols.TP;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class TransportConfigurationBuilder<T extends TP>
extends AbstractProtocolConfigurationBuilder<T, TransportConfiguration<T>>
implements TransportConfiguration<T> {
    private final PathAddress address;
    private final EnumMap<ThreadPoolResourceDefinition, ValueDependency<ThreadPoolFactory>> threadPoolFactories = new EnumMap(ThreadPoolResourceDefinition.class);
    private volatile ValueDependency<TimerFactory> timerFactory;
    private volatile ValueDependency<SocketBinding> socketBinding;
    private volatile ValueDependency<SocketBinding> diagnosticsSocketBinding;
    private volatile TransportConfiguration.Topology topology = null;

    public TransportConfigurationBuilder(PathAddress address) {
        super(address.getLastElement().getValue());
        this.address = address;
    }

    public ServiceName getServiceName() {
        return new SingletonProtocolServiceNameProvider(this.address).getServiceName();
    }

    @Override
    public ServiceBuilder<TransportConfiguration<T>> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        Stream.concat(this.threadPoolFactories.values().stream(), Stream.of(this.timerFactory, this.socketBinding, this.diagnosticsSocketBinding)).filter(Objects::nonNull).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public Builder<TransportConfiguration<T>> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.socketBinding = new InjectedValueDependency(CommonUnaryRequirement.SOCKET_BINDING.getServiceName(context, TransportResourceDefinition.Attribute.SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asString()), SocketBinding.class);
        this.diagnosticsSocketBinding = ModelNodes.optionalString((ModelNode)TransportResourceDefinition.Attribute.DIAGNOSTICS_SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model)).map(diagnosticsBinding -> new InjectedValueDependency(CommonUnaryRequirement.SOCKET_BINDING.getServiceName(context, diagnosticsBinding), SocketBinding.class)).orElse(null);
        final Optional machine = ModelNodes.optionalString((ModelNode)TransportResourceDefinition.Attribute.MACHINE.resolveModelAttribute((ExpressionResolver)context, model));
        final Optional rack = ModelNodes.optionalString((ModelNode)TransportResourceDefinition.Attribute.RACK.resolveModelAttribute((ExpressionResolver)context, model));
        final Optional site = ModelNodes.optionalString((ModelNode)TransportResourceDefinition.Attribute.SITE.resolveModelAttribute((ExpressionResolver)context, model));
        if (site.isPresent() || rack.isPresent() || machine.isPresent()) {
            this.topology = new TransportConfiguration.Topology(){

                public String getMachine() {
                    return machine.orElse(null);
                }

                public String getRack() {
                    return rack.orElse(null);
                }

                public String getSite() {
                    return site.orElse(null);
                }
            };
        }
        PathAddress address = context.getCurrentAddress();
        EnumSet.complementOf(EnumSet.of(ThreadPoolResourceDefinition.TIMER)).forEach(pool -> this.threadPoolFactories.put((ThreadPoolResourceDefinition)pool, (ValueDependency<ThreadPoolFactory>)new InjectedValueDependency((ServiceNameProvider)new ThreadPoolServiceNameProvider(address, pool.getPathElement()), ThreadPoolFactory.class)));
        this.timerFactory = new InjectedValueDependency((ServiceNameProvider)new ThreadPoolServiceNameProvider(address, ThreadPoolResourceDefinition.TIMER.getPathElement()), TimerFactory.class);
        return super.configure(context, model);
    }

    @Override
    public void accept(T protocol) {
        InetSocketAddress socketAddress = this.getSocketBinding().getSocketAddress();
        protocol.setBindAddress(socketAddress.getAddress());
        protocol.setBindPort(socketAddress.getPort());
        protocol.setThreadFactory((ThreadFactory)new ClassLoaderThreadFactory((ThreadFactory)new DefaultThreadFactory("", false), JChannelFactory.class.getClassLoader()));
        protocol.setDefaultThreadPool((Executor)((ThreadPoolFactory)this.threadPoolFactories.get(ThreadPoolResourceDefinition.DEFAULT).getValue()).get());
        protocol.setInternalThreadPool((Executor)((ThreadPoolFactory)this.threadPoolFactories.get(ThreadPoolResourceDefinition.INTERNAL).getValue()).get());
        protocol.setOOBThreadPool((Executor)((ThreadPoolFactory)this.threadPoolFactories.get(ThreadPoolResourceDefinition.OOB).getValue()).get());
        protocol.setTimer((TimeScheduler)((TimerFactory)this.timerFactory.getValue()).get());
        Optional<InetSocketAddress> diagnosticsSocketAddress = Optional.ofNullable(this.diagnosticsSocketBinding).map(Value::getValue).map(SocketBinding::getSocketAddress);
        protocol.setValue("enable_diagnostics", (Object)diagnosticsSocketAddress.isPresent());
        diagnosticsSocketAddress.ifPresent(address -> {
            protocol.setValue("diagnostics_addr", (Object)address.getAddress());
            protocol.setValue("diagnostics_port", (Object)address.getPort());
        });
    }

    public TransportConfiguration<T> getValue() {
        return this;
    }

    public SocketBinding getSocketBinding() {
        return (SocketBinding)this.socketBinding.getValue();
    }

    public TransportConfiguration.Topology getTopology() {
        return this.topology;
    }
}

