/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.clustering.controller.descriptions.SimpleResourceDescriptionResolver;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolMetricsHandler;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.Channel;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;

public class ProtocolResourceRegistrationHandler
implements OperationStepHandler,
ProtocolMetricsHandler.ProtocolLocator {
    private final String name;
    private final PathAddress stackAddress;

    public ProtocolResourceRegistrationHandler(String name, PathAddress stackAddress) {
        this.name = name;
        this.stackAddress = stackAddress;
    }

    @Override
    public Protocol findProtocol(ServiceRegistry registry, PathAddress address) throws ClassNotFoundException, ModuleLoadException {
        ChannelFactory factory;
        Channel channel;
        String channelName = address.getElement(address.size() - 2).getValue();
        String protocolName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = registry.getService(ChannelServiceName.CHANNEL.getServiceName(channelName));
        if (controller != null && (channel = (Channel)controller.getValue()) != null && (factory = (ChannelFactory)(controller = registry.getService(ChannelServiceName.FACTORY.getServiceName(channelName))).getValue()) != null) {
            ProtocolStackConfiguration configuration = factory.getProtocolStackConfiguration();
            if (configuration.getTransport().getName().equals(protocolName)) {
                Class<Protocol> protocolClass = configuration.getModuleLoader().loadModule(configuration.getTransport().getModule()).getClassLoader().loadClass(configuration.getTransport().getProtocolClassName()).asSubclass(Protocol.class);
                return channel.getProtocolStack().findProtocol(protocolClass);
            }
            for (ProtocolConfiguration protocol : configuration.getProtocols()) {
                if (!protocol.getName().equals(protocolName)) continue;
                Class<Protocol> protocolClass = configuration.getModuleLoader().loadModule(protocol.getModule()).getClassLoader().loadClass(protocol.getProtocolClassName()).asSubclass(Protocol.class);
                return channel.getProtocolStack().findProtocol(protocolClass);
            }
        }
        return null;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        OverrideDescriptionProvider provider = new OverrideDescriptionProvider(){

            public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }

            public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                JGroupsResourceDescriptionResolver resolver = new JGroupsResourceDescriptionResolver();
                String description = resolver.getChildTypeDescription(ProtocolResourceDefinition.WILDCARD_PATH.getKey(), locale, resolver.getResourceBundle(locale));
                ModelNode result = new ModelNode();
                result.get("description").set(description);
                return Collections.singletonMap(ProtocolResourceDefinition.WILDCARD_PATH.getKey(), result);
            }
        };
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate().registerOverrideModel(this.name, provider);
        Resource stackResource = context.readResourceFromRoot(this.stackAddress, false);
        for (String name : stackResource.getChildrenNames(TransportResourceDefinition.WILDCARD_PATH.getKey())) {
            PathAddress transportAddress = this.stackAddress.append(new PathElement[]{TransportResourceDefinition.pathElement(name)});
            ModelNode transport = context.readResourceFromRoot(transportAddress, false).getModel();
            ModuleIdentifier module = ModelNodes.asModuleIdentifier((ModelNode)ProtocolResourceDefinition.Attribute.MODULE.getDefinition().resolveModelAttribute(context, transport));
            Class<? extends Protocol> transportClass = ProtocolResourceRegistrationHandler.findProtocolClass(context, name, module);
            registration.registerSubModel(this.createProtocolResourceDefinition(name, transportClass)).setRuntimeOnly(true);
            resource.registerChild(ProtocolResourceDefinition.pathElement(name), (Resource)PlaceholderResource.INSTANCE);
        }
        for (String name : stackResource.getChildrenNames(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
            Resource protocolResource = context.readResourceFromRoot(this.stackAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement(name)}), false);
            ModuleIdentifier module = ModelNodes.asModuleIdentifier((ModelNode)ProtocolResourceDefinition.Attribute.MODULE.getDefinition().resolveModelAttribute(context, protocolResource.getModel()));
            Class<? extends Protocol> protocolClass = ProtocolResourceRegistrationHandler.findProtocolClass(context, name, module);
            registration.registerSubModel(this.createProtocolResourceDefinition(name, protocolClass)).setRuntimeOnly(true);
            resource.registerChild(ProtocolResourceDefinition.pathElement(name), (Resource)PlaceholderResource.INSTANCE);
        }
        if (stackResource.hasChild(RelayResourceDefinition.PATH)) {
            registration.registerSubModel(this.createProtocolResourceDefinition("relay.RELAY2", RELAY2.class)).setRuntimeOnly(true);
            resource.registerChild(ProtocolResourceDefinition.pathElement("relay.RELAY2"), (Resource)PlaceholderResource.INSTANCE);
        }
    }

    private ResourceDefinition createProtocolResourceDefinition(String protocolName, Class<? extends Protocol> protocolClass) {
        SimpleResourceDescriptionResolver resolver = new SimpleResourceDescriptionResolver(protocolName, protocolClass.getSimpleName());
        ResourceBuilder builder = ResourceBuilder.Factory.create((PathElement)ProtocolResourceDefinition.pathElement(protocolName), (StandardResourceDescriptionResolver)resolver).setRuntime();
        ProtocolMetricsHandler handler = new ProtocolMetricsHandler(this);
        for (Map.Entry<String, ProtocolMetricsHandler.Attribute> entry : ProtocolMetricsHandler.findProtocolAttributes(protocolClass).entrySet()) {
            String name = entry.getKey();
            ProtocolMetricsHandler.Attribute attribute = entry.getValue();
            ProtocolMetricsHandler.FieldType type = ProtocolMetricsHandler.FieldType.valueOf(attribute.getType());
            resolver.addDescription(name, attribute.getDescription());
            builder.addMetric((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type.getModelType(), true).setStorageRuntime()).build(), (OperationStepHandler)handler);
        }
        return builder.build();
    }

    static Class<? extends Protocol> findProtocolClass(OperationContext context, String protocolName, ModuleIdentifier module) throws OperationFailedException {
        String className = protocolName;
        if (module.equals(ProtocolConfiguration.DEFAULT_MODULE) && !protocolName.startsWith("org.jgroups.protocols")) {
            className = "org.jgroups.protocols." + protocolName;
        }
        try {
            ModuleLoader loader = (ModuleLoader)context.getServiceRegistry(false).getRequiredService(Services.JBOSS_SERVICE_MODULE_LOADER).getValue();
            return loader.loadModule(module).getClassLoader().loadClass(className).asSubclass(Protocol.class);
        }
        catch (ClassNotFoundException | ModuleLoadException e) {
            throw JGroupsLogger.ROOT_LOGGER.unableToLoadProtocolClass(className);
        }
    }
}

