/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class JChannelFactoryBuilder
implements ResourceServiceBuilder<ChannelFactory>,
Value<ChannelFactory>,
ProtocolStackConfiguration {
    private final InjectedValue<ProtocolDefaults> defaults = new InjectedValue();
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final String name;
    private ValueDependency<TransportConfiguration> transport = null;
    private final List<ValueDependency<ProtocolConfiguration>> protocols = new LinkedList<ValueDependency<ProtocolConfiguration>>();
    private ValueDependency<RelayConfiguration> relay = null;

    public JChannelFactoryBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.name);
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ProtocolDefaultsBuilder.SERVICE_NAME, ProtocolDefaults.class, this.defaults).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.environment).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (this.transport != null) {
            this.transport.register(builder);
        }
        for (Dependency dependency : this.protocols) {
            dependency.register(builder);
        }
        if (this.relay != null) {
            this.relay.register(builder);
        }
        return builder;
    }

    public Builder<ChannelFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.hasDefined(TransportResourceDefinition.WILDCARD_PATH.getKey())) {
            throw JGroupsLogger.ROOT_LOGGER.transportNotDefined(this.name);
        }
        Property transport = model.get(TransportResourceDefinition.WILDCARD_PATH.getKey()).asProperty();
        this.transport = new InjectedValueDependency((ServiceNameProvider)new TransportConfigurationBuilder(this.name, transport.getName()), TransportConfiguration.class);
        this.protocols.clear();
        if (model.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property protocol : model.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                this.protocols.add((ValueDependency<ProtocolConfiguration>)new InjectedValueDependency((ServiceNameProvider)new ProtocolConfigurationBuilder(this.name, protocol.getName()), ProtocolConfiguration.class));
            }
        }
        this.relay = model.hasDefined(RelayResourceDefinition.PATH.getKey()) ? new InjectedValueDependency((ServiceNameProvider)new RelayConfigurationBuilder(this.name), RelayConfiguration.class) : null;
        return this;
    }

    public ChannelFactory getValue() {
        return new JChannelFactory(this);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDefaultProperties(String protocol) {
        return ((ProtocolDefaults)this.defaults.getValue()).getProperties(protocol);
    }

    public TransportConfiguration getTransport() {
        return this.transport != null ? (TransportConfiguration)this.transport.getValue() : null;
    }

    public List<ProtocolConfiguration> getProtocols() {
        ArrayList<ProtocolConfiguration> protocols = new ArrayList<ProtocolConfiguration>(this.protocols.size());
        for (Value value : this.protocols) {
            protocols.add((ProtocolConfiguration)value.getValue());
        }
        return protocols;
    }

    public String getNodeName() {
        return ((ServerEnvironment)this.environment.getValue()).getNodeName();
    }

    public RelayConfiguration getRelay() {
        return this.relay != null ? (RelayConfiguration)this.relay.getValue() : null;
    }

    public ModuleLoader getModuleLoader() {
        return (ModuleLoader)this.loader.getValue();
    }
}

