/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.ForkChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class ForkChannelFactoryBuilder
implements ResourceServiceBuilder<ChannelFactory>,
Value<ChannelFactory> {
    private final String channelName;
    private final InjectedValue<Channel> parentChannel = new InjectedValue();
    private final InjectedValue<ChannelFactory> parentFactory = new InjectedValue();
    private final List<ValueDependency<ProtocolConfiguration>> protocols = new LinkedList<ValueDependency<ProtocolConfiguration>>();

    public ForkChannelFactoryBuilder(String channelName) {
        this.channelName = channelName;
    }

    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.channelName);
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ChannelServiceName.CONNECTOR.getServiceName(this.channelName), Channel.class, this.parentChannel).addDependency(ChannelServiceName.FACTORY.getServiceName(this.channelName), ChannelFactory.class, this.parentFactory).setInitialMode(ServiceController.Mode.ON_DEMAND);
        for (Dependency dependency : this.protocols) {
            dependency.register(builder);
        }
        return builder;
    }

    public ChannelFactory getValue() {
        ArrayList<ProtocolConfiguration> protocols = new ArrayList<ProtocolConfiguration>(this.protocols.size());
        for (Value value : this.protocols) {
            protocols.add((ProtocolConfiguration)value.getValue());
        }
        return new ForkChannelFactory((Channel)this.parentChannel.getValue(), (ChannelFactory)this.parentFactory.getValue(), protocols);
    }

    public Builder<ChannelFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.protocols.clear();
        if (model.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property protocol : model.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                this.protocols.add((ValueDependency<ProtocolConfiguration>)new InjectedValueDependency((ServiceNameProvider)new ProtocolConfigurationBuilder(this.channelName, protocol.getName()), ProtocolConfiguration.class));
            }
        }
        return this;
    }
}

