/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.time.Duration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.concurrent.NonBlockingRejectedExecutionHandler;
import org.jboss.as.clustering.controller.DurationAttributeDefinition;
import org.jboss.as.clustering.infinispan.executors.DefaultNonBlockingThreadFactory;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceRegistration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class ClientThreadPoolResourceDefinitionRegistrar
extends ConfigurationResourceDefinitionRegistrar<ExecutorFactoryConfiguration, ExecutorFactoryConfigurationBuilder> {
    private final AttributeDefinition minThreads;
    private final AttributeDefinition maxThreads;
    private final AttributeDefinition queueLength;
    private final DurationAttributeDefinition keepAlive;

    ClientThreadPoolResourceDefinitionRegistrar(final ThreadPoolResourceRegistration<ExecutorFactoryConfiguration> pool) {
        super(new ConfigurationResourceDefinitionRegistrar.Configurator<ExecutorFactoryConfiguration>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return pool;
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return pool.getCapability();
            }
        });
        this.minThreads = pool.getMinThreads();
        this.maxThreads = pool.getMaxThreads();
        this.queueLength = pool.getQueueLength();
        this.keepAlive = pool.getKeepAlive();
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(this.minThreads, this.maxThreads, this.queueLength, this.keepAlive));
    }

    public ServiceDependency<ExecutorFactoryConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final int maxThreads = this.maxThreads.resolveModelAttribute(context, model).asInt();
        final int minThreads = this.minThreads.resolveModelAttribute(context, model).asInt();
        final int queueLength = this.queueLength.resolveModelAttribute(context, model).asInt();
        final Duration keepAlive = this.keepAlive.resolve(context, model);
        DefaultNonBlockingThreadFactory threadFactory = new DefaultNonBlockingThreadFactory(new DaemonThreadFactory("HotRod-client-async-pool"));
        RejectedExecutionHandler rejectionHandler = NonBlockingRejectedExecutionHandler.getInstance();
        final ExecutorFactory executorFactory = new ExecutorFactory(){
            final /* synthetic */ ThreadFactory val$threadFactory;
            final /* synthetic */ RejectedExecutionHandler val$rejectionHandler;
            {
                this.val$threadFactory = threadFactory;
                this.val$rejectionHandler = rejectedExecutionHandler;
            }

            public ExecutorService getExecutor(Properties property) {
                LinkedBlockingQueue<Runnable> queue = queueLength > 0 ? new LinkedBlockingQueue(queueLength) : new SynchronousQueue();
                return new ThreadPoolExecutor(minThreads, maxThreads, keepAlive.toMillis(), TimeUnit.MILLISECONDS, queue, this.val$threadFactory, this.val$rejectionHandler);
            }
        };
        return ServiceDependency.from((Supplier)new Supplier<ExecutorFactoryConfigurationBuilder>(){

            @Override
            public ExecutorFactoryConfigurationBuilder get() {
                return new ConfigurationBuilder().asyncExecutorFactory().factory(executorFactory);
            }
        });
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger index = new AtomicInteger(0);
        private final String name;

        DaemonThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable task) {
            Thread thread = new Thread(task, String.join((CharSequence)"-", this.name, String.valueOf(this.index.getAndIncrement())));
            thread.setDaemon(true);
            return thread;
        }
    }
}

