/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.client.service;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.Lifecycle;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public enum RemoteCacheServiceInstallerFactory implements Function<BinaryServiceConfiguration, ServiceInstaller>
{
    INSTANCE;


    @Override
    public ServiceInstaller apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency container = configuration.getServiceDependency(HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER);
        final String cacheName = configuration.getChildName();
        Supplier cache = new Supplier<RemoteCache<?, ?>>(){

            @Override
            public RemoteCache<?, ?> get() {
                return ((RemoteCacheContainer)container.get()).getCache(cacheName);
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)cache).blocking()).onStart(Lifecycle::start)).onStop(Lifecycle::stop)).provides(configuration.resolveServiceName(HotRodServiceDescriptor.REMOTE_CACHE))).requires(List.of(container, configuration.getServiceDependency(HotRodServiceDescriptor.REMOTE_CACHE_CONFIGURATION)))).build();
    }
}

