/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.ejb3.cache.backing.infinispan;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.jboss.as.clustering.MarshalledValue;
import org.jboss.as.clustering.MarshalledValueFactory;
import org.jboss.as.clustering.ejb3.cache.backing.infinispan.InfinispanEjbMessages;
import org.jboss.as.clustering.ejb3.cache.backing.infinispan.LockKeyFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.lock.TimeoutException;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.IdentifierFactory;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.spi.GroupCompatibilityChecker;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntryStore;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.logging.Logger;

@Listener
public class InfinispanBackingCacheEntryStore<K extends Serializable, V extends Cacheable<K>, E extends BackingCacheEntry<K, V>, C>
extends AbstractBackingCacheEntryStore<K, V, E>
implements KeyGenerator<K> {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private final SharedLocalYieldingClusterLockManager lockManager;
    private final LockKeyFactory<K> lockKeyFactory;
    private final MarshalledValueFactory<C> valueFactory;
    private final C context;
    private final boolean controlCacheLifecycle;
    private final Cache<K, MarshalledValue<E, C>> cache;
    private final CacheInvoker invoker;
    private final PassivationManager<K, E> passivationManager;
    private final boolean clustered;
    private final Random random = new Random(System.currentTimeMillis());
    private final Registry<String, ?> registry;
    private final IdentifierFactory<K> identifierFactory;
    private final KeyAffinityService<K> affinity;

    public InfinispanBackingCacheEntryStore(Cache<K, MarshalledValue<E, C>> cache, CacheInvoker invoker, IdentifierFactory<K> identifierFactory, KeyAffinityServiceFactory affinityFactory, PassivationManager<K, E> passivationManager, StatefulTimeoutInfo timeout, ClusteredBackingCacheEntryStoreConfig config, boolean controlCacheLifecycle, MarshalledValueFactory<C> valueFactory, C context, SharedLocalYieldingClusterLockManager lockManager, LockKeyFactory<K> lockKeyFactory, Registry<String, ?> registry) {
        super(timeout, (BackingCacheEntryStoreConfig)config);
        this.cache = cache;
        this.invoker = invoker;
        this.identifierFactory = identifierFactory;
        this.passivationManager = passivationManager;
        this.controlCacheLifecycle = controlCacheLifecycle;
        this.clustered = cache.getCacheConfiguration().clustering().cacheMode().isClustered();
        this.valueFactory = valueFactory;
        this.context = context;
        this.lockManager = this.clustered ? lockManager : null;
        this.lockKeyFactory = lockKeyFactory;
        this.registry = registry;
        this.affinity = affinityFactory.createService(cache, (KeyGenerator)this);
    }

    public void start() {
        if (this.controlCacheLifecycle) {
            this.cache.start();
        }
        this.affinity.start();
    }

    public void stop() {
        this.affinity.stop();
        if (this.controlCacheLifecycle) {
            this.cache.stop();
        }
    }

    public K createIdentifier() {
        return (K)((Serializable)this.affinity.getKeyForAddress(this.cache.getCacheManager().getAddress()));
    }

    public K getKey() {
        return (K)((Serializable)this.identifierFactory.createIdentifier());
    }

    public boolean hasAffinity(K key) {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        if (dist != null) {
            DataLocality locality = dist.getLocality(key);
            return locality.isLocal() || locality.isUncertain();
        }
        return true;
    }

    public Affinity getStrictAffinity() {
        return new ClusterAffinity(this.cache.getCacheManager().getClusterName());
    }

    public Affinity getWeakAffinity(K key) {
        Map.Entry entry;
        List addresses;
        if (!this.hasAffinity(key) && !(addresses = this.cache.getAdvancedCache().getDistributionManager().locate(key)).contains(this.cache.getCacheManager().getAddress()) && (entry = this.registry.getRemoteEntry(addresses.get(this.random.nextInt(addresses.size())))) != null) {
            return new NodeAffinity((String)entry.getKey());
        }
        return new NodeAffinity((String)this.registry.getLocalEntry().getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> insert(E entry) {
        final Serializable id = (Serializable)entry.getId();
        this.trace("insert(%s)", id);
        this.acquireSessionOwnership(id, true);
        try {
            final MarshalledValue<E, C> value = this.marshalEntry(entry);
            Operation<Void> operation = new Operation<Void>(){

                public Void invoke(Cache<K, MarshalledValue<E, C>> cache) {
                    cache.put((Object)id, (Object)value);
                    return null;
                }
            };
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[]{Flag.SKIP_REMOTE_LOOKUP});
        }
        finally {
            this.releaseSessionOwnership(id, false);
        }
        return Collections.emptySet();
    }

    public E get(K id, boolean lock) {
        this.trace("get(%s. %s)", id, lock);
        if (lock) {
            this.acquireSessionOwnership(id, false);
        }
        Operation operation = new Operation<MarshalledValue<E, C>>((Serializable)id){
            final /* synthetic */ Serializable val$id;
            {
                this.val$id = serializable;
            }

            public MarshalledValue<E, C> invoke(Cache<K, MarshalledValue<E, C>> cache) {
                return (MarshalledValue)cache.get((Object)this.val$id);
            }
        };
        return this.unmarshalEntry(id, (MarshalledValue)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(E entry, boolean modified) {
        final Serializable id = (Serializable)entry.getId();
        this.trace("update(%s, %s)", id, modified);
        try {
            if (modified) {
                final MarshalledValue<E, C> value = this.marshalEntry(entry);
                Operation<Void> operation = new Operation<Void>(){

                    public Void invoke(Cache<K, MarshalledValue<E, C>> cache) {
                        cache.put((Object)id, (Object)value);
                        return null;
                    }
                };
                this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[]{Flag.SKIP_REMOTE_LOOKUP});
            }
        }
        finally {
            this.releaseSessionOwnership(id, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove(K id) {
        this.trace("remove(%s)", id);
        Operation operation = new Operation<MarshalledValue<E, C>>((Serializable)id){
            final /* synthetic */ Serializable val$id;
            {
                this.val$id = serializable;
            }

            public MarshalledValue<E, C> invoke(Cache<K, MarshalledValue<E, C>> cache) {
                return (MarshalledValue)cache.remove((Object)this.val$id);
            }
        };
        try {
            E e = this.unmarshalEntry(id, (MarshalledValue)this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[0]));
            return e;
        }
        finally {
            this.releaseSessionOwnership(id, true);
        }
    }

    private K unmarshalKey(MarshalledValue<K, C> key) {
        try {
            return (K)((Serializable)key.get(this.context));
        }
        catch (Exception e) {
            throw InfinispanEjbMessages.MESSAGES.deserializationFailure(e, key);
        }
    }

    private MarshalledValue<E, C> marshalEntry(E value) {
        return this.valueFactory.createMarshalledValue(value);
    }

    private E unmarshalEntry(K id, MarshalledValue<E, C> value) {
        if (value == null) {
            return null;
        }
        try {
            return (E)((BackingCacheEntry)value.get(this.context));
        }
        catch (Exception e) {
            throw InfinispanEjbMessages.MESSAGES.deserializationFailure(e, id);
        }
    }

    private SharedLocalYieldingClusterLockManager.LockResult acquireSessionOwnership(K key, boolean newLock) {
        if (this.lockManager == null) {
            return null;
        }
        Serializable lockKey = this.lockKeyFactory.createLockKey(key);
        this.trace("Acquiring %slock on %s", newLock ? "new " : "", lockKey);
        long timeout = this.cache.getCacheConfiguration().locking().lockAcquisitionTimeout();
        try {
            SharedLocalYieldingClusterLockManager.LockResult result = this.lockManager.lock(lockKey, timeout, newLock);
            this.trace("Lock acquired (%s) on %s", result, lockKey);
            return result;
        }
        catch (TimeoutException e) {
            throw InfinispanEjbMessages.MESSAGES.lockAcquisitionTimeout(lockKey, timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw InfinispanEjbMessages.MESSAGES.lockAcquisitionInterruption(e, lockKey);
        }
    }

    private void releaseSessionOwnership(K key, boolean remove) {
        if (this.lockManager != null) {
            Serializable lockKey = this.lockKeyFactory.createLockKey(key);
            this.trace("Releasing %slock on %s", remove ? "and removing " : "", lockKey);
            this.lockManager.unlock(lockKey, remove);
            this.trace("Released %slock on %s", remove ? "and removed " : "", lockKey);
        }
    }

    public void passivate(final E entry) {
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<K, MarshalledValue<E, C>> cache) {
                cache.evict(entry.getId());
                return null;
            }
        };
        this.invoker.invoke(this.cache, (CacheInvoker.Operation)operation, new Flag[]{Flag.FAIL_SILENTLY});
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean isCompatibleWith(GroupCompatibilityChecker other) {
        if (other instanceof InfinispanBackingCacheEntryStore) {
            InfinispanBackingCacheEntryStore store = (InfinispanBackingCacheEntryStore)other;
            return this.cache.getCacheManager() == store.cache.getCacheManager();
        }
        return false;
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<MarshalledValue<K, C>, MarshalledValue<E, C>> event) {
        if (this.passivationManager != null && !event.isPre()) {
            K key = this.unmarshalKey((MarshalledValue)event.getKey());
            this.trace("activated(%s)", key);
            this.passivationManager.postActivate(this.unmarshalEntry(key, (MarshalledValue)event.getValue()));
        }
    }

    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<MarshalledValue<K, C>, MarshalledValue<E, C>> event) {
        if (this.passivationManager != null && event.isPre()) {
            K key = this.unmarshalKey((MarshalledValue)event.getKey());
            this.trace("passivated(%s)", key);
            this.passivationManager.prePassivate(this.unmarshalEntry(key, (MarshalledValue)event.getValue()));
        }
    }

    private void trace(String message, Object ... args) {
        if (this.log.isTraceEnabled()) {
            this.log.tracef(message, args);
        }
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<K, MarshalledValue<E, C>, R> {
        Operation() {
        }
    }
}

