/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.network;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.network.ClientMapping;
import org.wildfly.clustering.ejb.infinispan.network.ClientMappingsRegistryEntry;
import org.wildfly.clustering.server.Group;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class ClientMappingsRegistryEntryServiceInstallerFactory
implements Function<BinaryServiceConfiguration, ServiceInstaller> {
    private final ServiceDependency<List<ClientMapping>> clientMappings;

    public ClientMappingsRegistryEntryServiceInstallerFactory(ServiceDependency<List<ClientMapping>> clientMappings) {
        this.clientMappings = clientMappings;
    }

    @Override
    public ServiceInstaller apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency<List<ClientMapping>> clientMappings = this.clientMappings;
        final ServiceDependency group = configuration.getServiceDependency(ClusteringServiceDescriptor.GROUP);
        Supplier<Map.Entry<String, List<ClientMapping>>> entry = new Supplier<Map.Entry<String, List<ClientMapping>>>(){

            @Override
            public Map.Entry<String, List<ClientMapping>> get() {
                return new ClientMappingsRegistryEntry(((Group)group.get()).getLocalMember().getName(), (List)clientMappings.get());
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)entry).provides(configuration.resolveServiceName(ClusteringServiceDescriptor.REGISTRY_ENTRY))).requires(List.of(group, this.clientMappings))).build();
    }
}

