/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.security.PrivilegedAction;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataKey;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimeoutMetaData;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.security.manager.WildFlySecurityManager;

public class TimerTask<I, V>
implements Predicate<I>,
AutoCloseable {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(TimerTask.class, WildFlySecurityManager.getClassLoaderPrivileged(TimerTask.class));
    private final ExecutorService executor = Executors.newSingleThreadExecutor(THREAD_FACTORY);
    private final Configuration<I, V> configuration;

    TimerTask(Configuration<I, V> configuration) {
        this.configuration = configuration;
    }

    @Override
    public void close() {
        WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                TimerTask.this.executor.shutdown();
                return null;
            }
        });
    }

    @Override
    public boolean test(final I id) {
        final TimerFactory<I, V> timerFactory = this.configuration.getTimerFactory();
        final TimerMetaDataFactory metaDataFactory = timerFactory.getMetaDataFactory();
        final Scheduler<I, TimeoutMetaData> scheduler = this.configuration.getScheduler();
        final TimerManager<I> manager = this.configuration.getTimerManager();
        final TimerRegistry<I> registry = this.configuration.getTimerRegistry();
        final ScheduledEntries<I, Instant> entries = this.configuration.getScheduledEntries();
        final Supplier<Locality> localityProvider = this.configuration::getLocality;
        final InfinispanTimerMetaDataKey<I> key = new InfinispanTimerMetaDataKey<I>(id);
        if (!localityProvider.get().isLocal(key)) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Skipping timeout processing of non-local timer %s", id);
            return true;
        }
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                InfinispanEjbLogger.ROOT_LOGGER.debugf("Initiating timeout for timer %s", id);
                Batch batch = (Batch)manager.getBatchFactory().get();
                try {
                    Boolean bl;
                    Object value = metaDataFactory.findValue(id);
                    if (value == null) {
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer not found %s", id);
                        Boolean bl2 = true;
                        return bl2;
                    }
                    TimerMetaData metaData = metaDataFactory.createTimerMetaData(id, value);
                    Optional currentTimeoutReference = metaData.getNextTimeout();
                    if (currentTimeoutReference.isEmpty()) {
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Unexpected timeout event triggered for %s", id);
                        Boolean bl3 = false;
                        return bl3;
                    }
                    Instant now = Instant.now();
                    Instant currentTimeout = (Instant)currentTimeoutReference.get();
                    if (currentTimeout.isAfter(now)) {
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Timeout for timer %s initiated prematurely @ %s", id, currentTimeout);
                        Boolean bl4 = false;
                        return bl4;
                    }
                    Optional originalLastTimeout = metaData.getLastTimeout();
                    metaData.setLastTimeout(currentTimeout);
                    Optional nextTimeout = metaData.getNextTimeout();
                    if (nextTimeout.orElse(now).isBefore(now)) {
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Skipping notification of missed timeout for timer %s @ %s", id, currentTimeout);
                    } else {
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Triggering timeout for timer %s @ %s", id, currentTimeout);
                        Timer timer = timerFactory.createTimer(id, (ImmutableTimerMetaData)metaData, manager, scheduler);
                        try {
                            timer.invoke();
                        }
                        catch (ExecutionException e) {
                            InfinispanEjbLogger.ROOT_LOGGER.error(e.getLocalizedMessage(), e);
                        }
                        catch (RejectedExecutionException e) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("EJB component is suspended - could not invoke timeout for timer %s", id);
                            metaData.setLastTimeout((Instant)originalLastTimeout.orElse(null));
                            batch.discard();
                            Boolean bl5 = false;
                            if (batch != null) {
                                batch.close();
                            }
                            return bl5;
                        }
                        if (timer.isCanceled()) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timeout callback canceled timer %s", id);
                            Boolean bl6 = true;
                            return bl6;
                        }
                    }
                    if (nextTimeout.isEmpty()) {
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer %s has expired", id);
                        registry.unregister(id);
                        metaDataFactory.remove(id);
                        bl = true;
                        return bl;
                    }
                    if (!((Locality)localityProvider.get()).isLocal((Object)key)) {
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer %s is no longer local", id);
                        bl = true;
                        return bl;
                    }
                    InfinispanEjbLogger.ROOT_LOGGER.debugf("Rescheduling timer %s for next timeout %s", id, nextTimeout.get());
                    entries.add(id, (Object)((Instant)nextTimeout.get()));
                    bl = false;
                    return bl;
                }
                catch (Error | RuntimeException e) {
                    batch.discard();
                    throw e;
                }
                finally {
                    if (batch != null) {
                        try {
                            batch.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
        };
        try {
            return this.executor.submit(task).get();
        }
        catch (RejectedExecutionException e) {
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            InfinispanEjbLogger.ROOT_LOGGER.info(e.getLocalizedMessage(), e);
            return false;
        }
    }

    static interface Configuration<I, V> {
        public TimerFactory<I, V> getTimerFactory();

        public TimerManager<I> getTimerManager();

        public Locality getLocality();

        public Scheduler<I, TimeoutMetaData> getScheduler();

        public ScheduledEntries<I, Instant> getScheduledEntries();

        public TimerRegistry<I> getTimerRegistry();
    }
}

