/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.ejb.cache.timer.DefaultImmutableTimerMetaData;
import org.wildfly.clustering.ejb.cache.timer.DefaultTimerMetaData;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.MutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerIndex;
import org.wildfly.clustering.ejb.cache.timer.TimerIndexKey;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntryFunction;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerIndexKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataKey;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerMetaData;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.offset.OffsetValue;

public class InfinispanTimerMetaDataFactory<I, C>
implements TimerMetaDataFactory<I, RemappableTimerMetaDataEntry<C>> {
    private final Cache<TimerIndexKey, I> indexCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> readCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> readForUpdateCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> writeCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> removeCache;
    private final TimerMetaDataConfiguration<C> config;
    private final CacheEntryMutatorFactory<TimerMetaDataKey<I>, OffsetValue<Duration>> mutatorFactory;
    private final org.wildfly.clustering.function.Supplier<CompletionStage<RemappableTimerMetaDataEntry<C>>> completed = org.wildfly.clustering.function.Supplier.of(CompletableFuture.completedStage(null));

    public InfinispanTimerMetaDataFactory(InfinispanTimerMetaDataConfiguration<C> config) {
        this.config = config;
        this.indexCache = config.getReadForUpdateCache();
        this.readCache = config.getCache();
        this.readForUpdateCache = config.getReadForUpdateCache();
        this.writeCache = config.getSilentWriteCache();
        this.removeCache = config.getWriteCache();
        this.mutatorFactory = config.getCacheEntryMutatorFactory(TimerMetaDataEntryFunction::new);
    }

    public CompletionStage<RemappableTimerMetaDataEntry<C>> createValueAsync(I id, Map.Entry<RemappableTimerMetaDataEntry<C>, TimerIndex> entry) {
        RemappableTimerMetaDataEntry<C> metaData = entry.getKey();
        TimerIndex index = entry.getValue();
        CompletableFuture existingIndex = index != null ? this.indexCache.putIfAbsentAsync((Object)new InfinispanTimerIndexKey(index), id) : CompletableFuture.completedStage(null);
        org.wildfly.clustering.function.Supplier createTimerMetaData = () -> this.writeCache.putAsync(new InfinispanTimerMetaDataKey<Object>(id), (Object)metaData).thenApply((Function)org.wildfly.clustering.function.Function.of((Object)metaData));
        return existingIndex.thenCompose(org.wildfly.clustering.function.Function.get((Supplier)createTimerMetaData).orDefault(Objects::isNull, this.completed));
    }

    public CompletionStage<RemappableTimerMetaDataEntry<C>> findValueAsync(I id) {
        return this.readForUpdateCache.getAsync(new InfinispanTimerMetaDataKey<I>(id));
    }

    public CompletionStage<RemappableTimerMetaDataEntry<C>> tryValueAsync(I id) {
        return this.readCache.getAsync(new InfinispanTimerMetaDataKey<I>(id));
    }

    public CompletionStage<Void> removeAsync(I id) {
        return this.removeCache.removeAsync(new InfinispanTimerMetaDataKey<I>(id)).thenAccept((java.util.function.Consumer)Consumer.empty());
    }

    public TimerMetaData createTimerMetaData(I id, RemappableTimerMetaDataEntry<C> entry) {
        Duration lastTimeout = entry.getLastTimeout();
        OffsetValue lastTimeoutOffset = OffsetValue.from((Duration)Optional.ofNullable(lastTimeout).orElse(Duration.ZERO));
        CacheEntryMutator mutator = this.mutatorFactory.createMutator(new InfinispanTimerMetaDataKey<I>(id), (Object)lastTimeoutOffset);
        return new DefaultTimerMetaData(this.config, (TimerMetaDataEntry)(lastTimeout != null ? new MutableTimerMetaDataEntry((ImmutableTimerMetaDataEntry)entry, lastTimeoutOffset) : entry), (Runnable)mutator);
    }

    public ImmutableTimerMetaData createImmutableTimerMetaData(RemappableTimerMetaDataEntry<C> entry) {
        return new DefaultImmutableTimerMetaData(this.config, entry);
    }
}

