/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.lang.reflect.Method;
import java.time.Instant;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.ejb.infinispan.timer.AbstractTimerCreationMetaDataEntry;
import org.wildfly.clustering.ejb.infinispan.timer.ScheduleTimerCreationMetaData;
import org.wildfly.clustering.ejb.infinispan.timer.ScheduleTimerOperatorFactory;
import org.wildfly.clustering.ejb.infinispan.timer.TimeoutDescriptor;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;

public class ScheduleTimerCreationMetaDataEntry<V>
extends AbstractTimerCreationMetaDataEntry<V>
implements ScheduleTimerCreationMetaData<V> {
    private final ImmutableScheduleExpression expression;
    private final TimeoutDescriptor descriptor;
    private volatile UnaryOperator<Instant> operator = null;

    public ScheduleTimerCreationMetaDataEntry(V context, ScheduleTimerConfiguration config, Method method) {
        this(context, config, method != null ? new TimeoutDescriptor(method) : null, ScheduleTimerOperatorFactory.INSTANCE.createOperator(config.getScheduleExpression()));
    }

    private ScheduleTimerCreationMetaDataEntry(V context, ScheduleTimerConfiguration config, TimeoutDescriptor descriptor, UnaryOperator<Instant> operator) {
        this(context, (Instant)operator.apply(null), config.getScheduleExpression(), descriptor, operator);
    }

    public ScheduleTimerCreationMetaDataEntry(V context, Instant start, ImmutableScheduleExpression expression, TimeoutDescriptor descriptor) {
        this(context, start, expression, descriptor, null);
    }

    private ScheduleTimerCreationMetaDataEntry(V context, Instant start, ImmutableScheduleExpression expression, TimeoutDescriptor descriptor, UnaryOperator<Instant> operator) {
        super(context, start);
        this.expression = expression;
        this.descriptor = descriptor;
        this.operator = operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnaryOperator<Instant> getOperator() {
        if (this.operator == null) {
            ScheduleTimerCreationMetaDataEntry scheduleTimerCreationMetaDataEntry = this;
            synchronized (scheduleTimerCreationMetaDataEntry) {
                if (this.operator == null) {
                    this.operator = ScheduleTimerOperatorFactory.INSTANCE.createOperator(this.expression);
                }
            }
        }
        return this.operator;
    }

    public ImmutableScheduleExpression getScheduleExpression() {
        return this.expression;
    }

    @Override
    public TimeoutDescriptor getTimeoutMatcher() {
        return this.descriptor;
    }

    @Override
    public Instant apply(Instant lastTimeout) {
        return lastTimeout != null ? (Instant)this.getOperator().apply(lastTimeout) : this.getStart();
    }
}

