/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import org.jboss.as.clustering.controller.EnumAttributeDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagementProvider;
import org.wildfly.clustering.ejb.timer.TimerManagementConfiguration;
import org.wildfly.clustering.ejb.timer.TimerManagementProvider;
import org.wildfly.clustering.infinispan.service.InfinispanCacheConfigurationAttributeGroup;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.server.service.CacheConfigurationAttributeGroup;
import org.wildfly.extension.clustering.ejb.DistributableEjbSubsystemResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.ejb.TimerContextMarshallerFactory;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class InfinispanTimerManagementResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    static final ResourceRegistration REGISTRATION = ResourceRegistration.of((PathElement)PathElement.pathElement((String)"infinispan-timer-management"));
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)TimerManagementProvider.SERVICE_DESCRIPTOR).build();
    static final CacheConfigurationAttributeGroup CACHE_ATTRIBUTE_GROUP = new InfinispanCacheConfigurationAttributeGroup(CAPABILITY);
    static final EnumAttributeDefinition<TimerContextMarshallerFactory> MARSHALLER = new EnumAttributeDefinition.Builder("marshaller", (Enum)TimerContextMarshallerFactory.JBOSS).build();
    static final AttributeDefinition MAX_ACTIVE_TIMERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-active-timers", ModelType.INT).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator((ParameterValidator)new IntRangeValidator(1))).build();

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = DistributableEjbSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(REGISTRATION.getPathElement());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)resolver).addAttributes(CACHE_ATTRIBUTE_GROUP.getAttributes())).addAttributes(List.of(MARSHALLER, MAX_ACTIVE_TIMERS))).addCapability(CAPABILITY)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final OptionalInt maxActiveTimers = Optional.ofNullable(MAX_ACTIVE_TIMERS.resolveModelAttribute(context, model).asIntOrNull()).map(OptionalInt::of).orElse(OptionalInt.empty());
        final Function marshallerFactory = (Function)((Object)MARSHALLER.resolve(context, model));
        TimerManagementConfiguration config = new TimerManagementConfiguration(){

            public Function<Module, ByteBufferMarshaller> getMarshallerFactory() {
                return marshallerFactory;
            }

            public OptionalInt getMaxActiveTimers() {
                return maxActiveTimers;
            }
        };
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (Object)new InfinispanTimerManagementProvider(config, CACHE_ATTRIBUTE_GROUP.resolve(context, model))).build();
    }
}

