/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.CacheEntryCreator;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanGroup;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataFactory;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanFactory;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;

public interface BeanFactory<K, V extends BeanInstance<K>, M>
extends ImmutableBeanFactory<K, V, M>,
CacheEntryCreator<V, M, K>,
CacheEntryRemover<K> {
    @Override
    public BeanMetaDataFactory<K, M> getMetaDataFactory();

    @Override
    public BeanGroupManager<K, V> getBeanGroupManager();

    default public CompletionStage<M> createValueAsync(V id, K groupId) {
        return this.getMetaDataFactory().createValueAsync(id, groupId);
    }

    default public CompletionStage<Void> removeAsync(K id) {
        return this.getMetaDataFactory().removeAsync(id);
    }

    default public CompletionStage<Void> purgeAsync(K id) {
        return this.getMetaDataFactory().purgeAsync(id);
    }

    default public MutableBean<K, V> createBean(K id, M value) {
        BeanMetaData<K> metaData = this.getMetaDataFactory().createBeanMetaData(id, value);
        BeanGroup group = this.getBeanGroupManager().getBeanGroup(metaData.getGroupId());
        return this.createBean(id, metaData, group);
    }

    public MutableBean<K, V> createBean(K var1, BeanMetaData<K> var2, BeanGroup<K, V> var3);
}

