/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.ejb.bean.BeanExpiration;
import org.wildfly.clustering.ejb.bean.ImmutableBeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanCreationMetaData;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanAccessMetaData;

public class CompositeImmutableBeanMetaData<K>
implements ImmutableBeanMetaData<K> {
    private final BeanCreationMetaData<K> creationMetaData;
    private final ImmutableBeanAccessMetaData accessMetaData;
    private final BeanExpiration expiration;

    public CompositeImmutableBeanMetaData(BeanCreationMetaData<K> creationMetaData, ImmutableBeanAccessMetaData accessMetaData, BeanExpiration expiration) {
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
        this.expiration = expiration;
    }

    public String getName() {
        return this.creationMetaData.getName();
    }

    public K getGroupId() {
        return this.creationMetaData.getGroupId();
    }

    public Instant getLastAccessTime() {
        return this.creationMetaData.getCreationTime().plus(this.accessMetaData.getLastAccessDuration());
    }

    public Duration getTimeout() {
        return this.expiration != null ? this.expiration.getTimeout() : null;
    }
}

