/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.wildfly.clustering.ee.Invoker;

public class RetryingInvoker
implements Invoker {
    private static final Logger LOGGER = Logger.getLogger(RetryingInvoker.class);
    private final long[] backOffIntervals;
    private final TimeUnit unit;

    public RetryingInvoker(long ... backOffIntervals) {
        this(backOffIntervals, TimeUnit.MILLISECONDS);
    }

    public RetryingInvoker(long[] backOffIntervals, TimeUnit unit) {
        this.backOffIntervals = backOffIntervals;
        this.unit = unit;
    }

    public <R> R invoke(Callable<R> task) throws Exception {
        Exception exception = null;
        for (int i = 0; i < this.backOffIntervals.length; ++i) {
            if (i > 0) {
                long delay = this.backOffIntervals[i];
                if (delay > 0L) {
                    try {
                        this.unit.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    Thread.yield();
                }
                if (Thread.currentThread().isInterrupted()) break;
            }
            try {
                return task.call();
            }
            catch (Exception e) {
                exception = e;
                LOGGER.debugf((Throwable)exception, "Attempt #%d failed", i + 1);
                continue;
            }
        }
        throw exception;
    }
}

