/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.ee.Manager;

public class ConcurrentManager<K, V>
implements Manager<K, V> {
    private final Map<K, Map.Entry<Integer, VolatileReference<V>>> objects = new ConcurrentHashMap<K, Map.Entry<Integer, VolatileReference<V>>>();
    private final BiFunction<K, Map.Entry<Integer, VolatileReference<V>>, Map.Entry<Integer, VolatileReference<V>>> addFunction = new BiFunction<K, Map.Entry<Integer, VolatileReference<V>>, Map.Entry<Integer, VolatileReference<V>>>(){

        @Override
        public Map.Entry<Integer, VolatileReference<V>> apply(K id, Map.Entry<Integer, VolatileReference<V>> entry) {
            Integer count = entry != null ? entry.getKey() + 1 : 0;
            VolatileReference reference = entry != null ? entry.getValue() : new VolatileReference();
            return new AbstractMap.SimpleImmutableEntry(count, reference);
        }
    };
    private final Consumer<V> createTask;
    private final BiFunction<K, Map.Entry<Integer, VolatileReference<V>>, Map.Entry<Integer, VolatileReference<V>>> removeFunction;

    public ConcurrentManager(Consumer<V> createTask, final Consumer<V> closeTask) {
        this.createTask = createTask;
        this.removeFunction = new BiFunction<K, Map.Entry<Integer, VolatileReference<V>>, Map.Entry<Integer, VolatileReference<V>>>(){

            @Override
            public Map.Entry<Integer, VolatileReference<V>> apply(K key, Map.Entry<Integer, VolatileReference<V>> entry) {
                int count = entry.getKey();
                VolatileReference reference = entry.getValue();
                if (count == 0) {
                    Object value = reference.get();
                    if (value != null) {
                        closeTask.accept(value);
                    }
                    return null;
                }
                return new AbstractMap.SimpleImmutableEntry(count - 1, reference);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V apply(final K key, Function<Runnable, V> factory) {
        Map.Entry<Integer, VolatileReference<V>> entry = this.objects.compute(key, this.addFunction);
        VolatileReference<V> reference = entry.getValue();
        if (reference.get() == null) {
            VolatileReference<V> volatileReference = reference;
            synchronized (volatileReference) {
                if (reference.get() == null) {
                    final Map<K, Map.Entry<Integer, VolatileReference<V>>> objects = this.objects;
                    final BiFunction<K, Map.Entry<Integer, VolatileReference<V>>, Map.Entry<Integer, VolatileReference<V>>> removeFunction = this.removeFunction;
                    Runnable closeTask = new Runnable(){

                        @Override
                        public void run() {
                            objects.compute(key, removeFunction);
                        }
                    };
                    V value = factory.apply(closeTask);
                    if (value != null) {
                        this.createTask.accept(value);
                        reference.accept(value);
                    } else {
                        closeTask.run();
                    }
                }
            }
        }
        return reference.get();
    }

    public static class VolatileReference<V>
    implements Supplier<V>,
    Consumer<V> {
        private volatile V value = null;

        @Override
        public void accept(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }
    }
}

