/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.validation;

import java.util.function.DoubleSupplier;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DoubleRangeValidator
extends ModelTypeValidator {
    public static final ParameterValidator NON_NEGATIVE = new DoubleRangeValidator(Bound.inclusive(0.0));
    public static final ParameterValidator POSITIVE = new DoubleRangeValidator(Bound.exclusive(0.0));
    public static final ParameterValidator FLOAT = new DoubleRangeValidator(Bound.inclusive(-3.4028234663852886E38), Bound.inclusive(3.4028234663852886E38));
    public static final ParameterValidator NON_NEGATIVE_FLOAT = new DoubleRangeValidator(Bound.inclusive(0.0), Bound.inclusive(3.4028234663852886E38));
    public static final ParameterValidator POSITIVE_FLOAT = new DoubleRangeValidator(Bound.inclusive(1.4E-45f), Bound.inclusive(3.4028234663852886E38));
    private final Bound lowerBound;
    private final Bound upperBound;

    DoubleRangeValidator(Bound lowerBound) {
        this(lowerBound, null);
    }

    DoubleRangeValidator(Bound lowerBound, Bound upperBound) {
        super(ModelType.DOUBLE);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void validateParameter(String parameterName, ModelNode parameterValue) throws OperationFailedException {
        super.validateParameter(parameterName, parameterValue);
        if (parameterValue.isDefined() && parameterValue.getType() != ModelType.EXPRESSION) {
            boolean exclusive;
            double bound;
            double value = parameterValue.asDouble();
            if (this.lowerBound != null) {
                bound = this.lowerBound.getAsDouble();
                boolean bl = exclusive = this.lowerBound.getType() == Bound.Type.EXCLUSIVE;
                if (value < bound || exclusive && value == bound) {
                    throw ClusteringLogger.ROOT_LOGGER.parameterValueOutOfBounds(parameterName, value, exclusive ? ">" : ">=", bound);
                }
            }
            if (this.upperBound != null) {
                bound = this.upperBound.getAsDouble();
                boolean bl = exclusive = this.upperBound.getType() == Bound.Type.EXCLUSIVE;
                if (value > bound || exclusive && value == bound) {
                    throw ClusteringLogger.ROOT_LOGGER.parameterValueOutOfBounds(parameterName, value, exclusive ? "<" : "<=", bound);
                }
            }
        }
    }

    public static interface Bound
    extends DoubleSupplier {
        public Type getType();

        public static Bound inclusive(final double value) {
            return new Bound(){

                @Override
                public double getAsDouble() {
                    return value;
                }

                @Override
                public Type getType() {
                    return Type.INCLUSIVE;
                }
            };
        }

        public static Bound exclusive(final double value) {
            return new Bound(){

                @Override
                public double getAsDouble() {
                    return value;
                }

                @Override
                public Type getType() {
                    return Type.EXCLUSIVE;
                }
            };
        }

        public static enum Type {
            INCLUSIVE,
            EXCLUSIVE;

        }
    }
}

