/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.BinaryServiceNameFactory;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ServiceNameFactory;
import org.jboss.as.clustering.controller.UnaryServiceNameFactory;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class IdentityCapabilityServiceConfigurator<T>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator {
    private final Function<CapabilityServiceSupport, ServiceName> requirementNameFactory;
    private volatile SupplierDependency<T> requirement;

    public IdentityCapabilityServiceConfigurator(ServiceName name, final ServiceNameFactory targetFactory) {
        this(name, new Function<CapabilityServiceSupport, ServiceName>(){

            @Override
            public ServiceName apply(CapabilityServiceSupport support) {
                return targetFactory.getServiceName(support);
            }
        });
    }

    public IdentityCapabilityServiceConfigurator(ServiceName name, final UnaryServiceNameFactory targetFactory, final String requirementName) {
        this(name, new Function<CapabilityServiceSupport, ServiceName>(){

            @Override
            public ServiceName apply(CapabilityServiceSupport support) {
                return targetFactory.getServiceName(support, requirementName);
            }
        });
    }

    public IdentityCapabilityServiceConfigurator(ServiceName name, final BinaryServiceNameFactory targetFactory, final String requirementParent, final String requirementChild) {
        this(name, new Function<CapabilityServiceSupport, ServiceName>(){

            @Override
            public ServiceName apply(CapabilityServiceSupport support) {
                return targetFactory.getServiceName(support, requirementParent, requirementChild);
            }
        });
    }

    private IdentityCapabilityServiceConfigurator(ServiceName name, Function<CapabilityServiceSupport, ServiceName> requirementNameFactory) {
        super(name);
        this.requirementNameFactory = requirementNameFactory;
    }

    @Override
    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.requirement = new ServiceSupplierDependency(this.requirementNameFactory.apply(support));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer consumer = this.requirement.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(consumer, Function.identity(), this.requirement);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }
}

