/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.Receiver;
import org.jgroups.StateTransferException;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.MethodCall;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.jmx.ResourceDMBean;
import org.jgroups.protocols.TP;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Promise;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

@MBean(description="JGroups channel")
public class JChannel
extends Channel {
    public static final String DEFAULT_PROTOCOL_STACK = "udp.xml";
    protected Address local_addr;
    protected List<AddressGenerator> address_generators;
    protected String name;
    protected String cluster_name;
    protected View my_view;
    protected ProtocolStack prot_stack;
    protected final Promise<StateTransferResult> state_promise = new Promise();
    protected boolean state_transfer_supported = false;
    protected volatile boolean flush_supported = false;
    protected final ConcurrentMap<String, Object> config = Util.createConcurrentMap(16);
    @ManagedAttribute(description="Collect channel statistics", writable=true)
    protected boolean stats = true;
    protected long sent_msgs = 0L;
    protected long received_msgs = 0L;
    protected long sent_bytes = 0L;
    protected long received_bytes = 0L;
    protected final DiagnosticsHandler.ProbeHandler probe_handler = new MyProbeHandler();

    public JChannel(boolean create_protocol_stack) {
        if (create_protocol_stack) {
            try {
                this.init(ConfiguratorFactory.getStackConfigurator(DEFAULT_PROTOCOL_STACK));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public JChannel() throws Exception {
        this(DEFAULT_PROTOCOL_STACK);
    }

    public JChannel(File properties) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(Element properties) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(URL properties) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(String props) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(props));
    }

    public JChannel(InputStream input) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(input));
    }

    public JChannel(ProtocolStackConfigurator configurator) throws Exception {
        this.init(configurator);
    }

    public JChannel(Protocol ... protocols) throws Exception {
        this(Arrays.asList(protocols));
    }

    public JChannel(Collection<Protocol> protocols) throws Exception {
        this.prot_stack = new ProtocolStack();
        this.setProtocolStack(this.prot_stack);
        for (Protocol prot : protocols) {
            this.prot_stack.addProtocol(prot);
            prot.setProtocolStack(this.prot_stack);
        }
        this.prot_stack.init();
        List<Protocol> prots = this.prot_stack.getProtocols();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Protocol prot : prots) {
            Configurator.resolveAndAssignFields(prot, map);
        }
    }

    public JChannel(JChannel ch) throws Exception {
        this.init(ch);
        this.discard_own_messages = ch.discard_own_messages;
    }

    @Override
    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    public void setProtocolStack(ProtocolStack stack) {
        this.prot_stack = stack;
        if (this.prot_stack != null) {
            this.prot_stack.setChannel(this);
        }
    }

    @Override
    public String getProperties() {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(true) : null;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean stats) {
        this.stats = stats;
    }

    @ManagedOperation
    public void resetStats() {
        this.received_bytes = 0L;
        this.sent_bytes = 0L;
        this.received_msgs = 0L;
        this.sent_msgs = 0L;
    }

    @ManagedAttribute
    public long getSentMessages() {
        return this.sent_msgs;
    }

    @ManagedAttribute
    public long getSentBytes() {
        return this.sent_bytes;
    }

    @ManagedAttribute
    public long getReceivedMessages() {
        return this.received_msgs;
    }

    @ManagedAttribute
    public long getReceivedBytes() {
        return this.received_bytes;
    }

    @ManagedAttribute
    public int getNumberOfTasksInTimer() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.size() : -1;
    }

    @ManagedAttribute
    public int getTimerThreads() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.getMinThreads() : -1;
    }

    @ManagedOperation
    public String dumpTimerQueue() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.dumpTimerTasks() : "<n/a";
    }

    @ManagedOperation
    public String printProtocolSpec(boolean include_properties) {
        ProtocolStack ps = this.getProtocolStack();
        return ps != null ? ps.printProtocolSpec(include_properties) : null;
    }

    @Override
    @ManagedOperation(description="Connects the channel to a group")
    public synchronized void connect(String cluster_name) throws Exception {
        this.connect(cluster_name, true);
    }

    @ManagedOperation(description="Connects the channel to a group")
    protected synchronized void connect(String cluster_name, boolean useFlushIfPresent) throws Exception {
        if (!this._preConnect(cluster_name)) {
            return;
        }
        if (cluster_name != null) {
            Event connect_event = useFlushIfPresent ? new Event(92, cluster_name) : new Event(2, cluster_name);
            this._connect(connect_event);
        }
        this.state = Channel.State.CONNECTED;
        this.notifyChannelConnected(this);
    }

    @Override
    public synchronized void connect(String cluster_name, Address target, long timeout) throws Exception {
        this.connect(cluster_name, target, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String cluster_name, Address target, long timeout, boolean useFlushIfPresent) throws Exception {
        if (!this._preConnect(cluster_name)) {
            return;
        }
        if (cluster_name == null) {
            this.state = Channel.State.CONNECTED;
            return;
        }
        boolean canFetchState = false;
        try {
            Event connect_event = useFlushIfPresent ? new Event(93, cluster_name) : new Event(80, cluster_name);
            this._connect(connect_event);
            this.state = Channel.State.CONNECTED;
            this.notifyChannelConnected(this);
            boolean bl = canFetchState = this.getView() != null && this.getView().size() > 1;
            if (canFetchState) {
                this.getState(target, timeout, false);
            }
        }
        finally {
            if (this.flushSupported() && useFlushIfPresent && (canFetchState || this.state != Channel.State.CONNECTED)) {
                this.stopFlush();
            }
        }
    }

    @Override
    @ManagedOperation(description="Disconnects the channel if connected")
    public synchronized void disconnect() {
        switch (this.state) {
            case OPEN: 
            case CLOSED: {
                return;
            }
            case CONNECTING: 
            case CONNECTED: {
                if (this.cluster_name != null) {
                    try {
                        this.down(new Event(4, this.local_addr));
                    }
                    catch (Throwable t) {
                        this.log.error(Util.getMessage("DisconnectFailure"), this.local_addr, t);
                    }
                }
                this.state = Channel.State.OPEN;
                this.stopStack(true, false);
                this.notifyChannelDisconnected(this);
                this.init();
                break;
            }
            default: {
                throw new IllegalStateException("state " + (Object)((Object)this.state) + " unknown");
            }
        }
    }

    @Override
    @ManagedOperation(description="Disconnects and destroys the channel")
    public synchronized void close() {
        this._close(true);
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStats() {
        Map<String, Long> tmp;
        Map<String, Object> retval = this.prot_stack.dumpStats();
        if (retval != null && (tmp = this.dumpChannelStats()) != null) {
            retval.put("channel", tmp);
        }
        return retval;
    }

    public Map<String, Object> dumpStats(String protocol_name, List<String> attrs) {
        return this.prot_stack.dumpStats(protocol_name, attrs);
    }

    @ManagedOperation
    public Map<String, Object> dumpStats(String protocol_name) {
        return this.prot_stack.dumpStats(protocol_name, null);
    }

    protected Map<String, Long> dumpChannelStats() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("sent_msgs", this.sent_msgs);
        retval.put("sent_bytes", this.sent_bytes);
        retval.put("received_msgs", this.received_msgs);
        retval.put("received_bytes", this.received_bytes);
        return retval;
    }

    @Override
    public void send(Message msg) throws Exception {
        this.checkClosedOrNotConnected();
        if (msg == null) {
            throw new NullPointerException("msg is null");
        }
        this.down(new Event(1, msg));
    }

    @Override
    public void send(Address dst, Object obj) throws Exception {
        this.send(new Message(dst, obj));
    }

    @Override
    public void send(Address dst, byte[] buf) throws Exception {
        this.send(new Message(dst, buf));
    }

    @Override
    public void send(Address dst, byte[] buf, int offset, int length) throws Exception {
        this.send(new Message(dst, buf, offset, length));
    }

    @Override
    public View getView() {
        return this.state == Channel.State.CONNECTED ? this.my_view : null;
    }

    @ManagedAttribute(name="view")
    public String getViewAsString() {
        View v = this.getView();
        return v != null ? v.toString() : "n/a";
    }

    @ManagedAttribute
    public static String getVersion() {
        return Version.printDescription();
    }

    @Override
    public Address getAddress() {
        return this.state == Channel.State.CLOSED ? null : this.local_addr;
    }

    @ManagedAttribute(name="address")
    public String getAddressAsString() {
        return this.local_addr != null ? this.local_addr.toString() : "n/a";
    }

    @ManagedAttribute(name="address_uuid")
    public String getAddressAsUUID() {
        return this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(Address member) {
        return member != null ? UUID.get(member) : null;
    }

    @Override
    @ManagedAttribute(writable=true, description="The logical name of this channel. Stays with the channel until the channel is closed")
    public void setName(String name) {
        if (name != null) {
            if (this.isConnected()) {
                throw new IllegalStateException("name cannot be set if channel is connected (should be done before)");
            }
            this.name = name;
            if (this.local_addr != null) {
                UUID.add(this.local_addr, this.name);
            }
        }
    }

    @Override
    public JChannel name(String name) {
        this.setName(name);
        return this;
    }

    public JChannel receiver(Receiver r) {
        this.setReceiver(r);
        return this;
    }

    @Override
    @ManagedAttribute(description="Returns cluster name this channel is connected to")
    public String getClusterName() {
        return this.state == Channel.State.CONNECTED ? this.cluster_name : null;
    }

    @Deprecated
    public AddressGenerator getAddressGenerator() {
        return this.address_generators == null || this.address_generators.isEmpty() ? null : this.address_generators.get(0);
    }

    @Deprecated
    public void setAddressGenerator(AddressGenerator address_generator) {
        this.addAddressGenerator(address_generator);
    }

    public void addAddressGenerator(AddressGenerator address_generator) {
        if (address_generator == null) {
            return;
        }
        if (this.address_generators == null) {
            this.address_generators = new ArrayList<AddressGenerator>(3);
        }
        this.address_generators.add(address_generator);
    }

    public boolean removeAddressGenerator(AddressGenerator address_generator) {
        return address_generator != null && this.address_generators != null && this.address_generators.remove(address_generator);
    }

    @Override
    public void getState(Address target, long timeout) throws Exception {
        this.getState(target, timeout, true);
    }

    public void getState(Address target, long timeout, boolean useFlushIfPresent) throws Exception {
        Callable<Boolean> flusher = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Util.startFlush(JChannel.this);
            }
        };
        this.getState(target, timeout, useFlushIfPresent ? flusher : null);
    }

    protected boolean _preConnect(String cluster_name) throws Exception {
        if (this.state == Channel.State.CONNECTED) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("already connected to " + this.cluster_name);
            }
            return false;
        }
        this.checkClosed();
        this.setAddress();
        Channel.State old_state = this.state;
        this.state = Channel.State.CONNECTING;
        try {
            this.startStack(cluster_name);
        }
        catch (Exception ex) {
            this.state = old_state;
            throw ex;
        }
        return true;
    }

    protected void _connect(Event connect_event) throws Exception {
        try {
            this.down(connect_event);
        }
        catch (Throwable t) {
            this.stopStack(true, false);
            this.state = Channel.State.OPEN;
            this.init();
            throw new Exception("connecting to channel \"" + connect_event.getArg() + "\" failed", t);
        }
    }

    protected void getState(Address target, long timeout, Callable<Boolean> flushInvoker) throws Exception {
        boolean initiateFlush;
        this.checkClosedOrNotConnected();
        if (!this.state_transfer_supported) {
            throw new IllegalStateException("fetching state will fail as state transfer is not supported. Add one of the state transfer protocols to your configuration");
        }
        if (target == null) {
            target = this.determineCoordinator();
        }
        if (target != null && this.local_addr != null && target.equals(this.local_addr)) {
            this.log.trace(this.local_addr + ": cannot get state from myself (" + target + "): probably the first member");
            return;
        }
        boolean bl = initiateFlush = this.flushSupported() && flushInvoker != null;
        if (initiateFlush) {
            boolean successfulFlush = false;
            try {
                successfulFlush = flushInvoker.call();
            }
            catch (Throwable e) {
                successfulFlush = false;
            }
            if (!successfulFlush) {
                throw new IllegalStateException("Node " + this.local_addr + " could not flush the cluster for state retrieval");
            }
        }
        this.state_promise.reset();
        StateTransferInfo state_info = new StateTransferInfo(target, timeout);
        long start = System.currentTimeMillis();
        this.down(new Event(19, state_info));
        StateTransferResult result = this.state_promise.getResult(state_info.timeout);
        if (initiateFlush) {
            this.stopFlush();
        }
        if (result == null) {
            throw new StateTransferException("timeout during state transfer (" + (System.currentTimeMillis() - start) + "ms)");
        }
        if (result.hasException()) {
            throw new StateTransferException("state transfer failed", result.getException());
        }
    }

    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.stats) {
                    ++this.received_msgs;
                    this.received_bytes += (long)msg.getLength();
                }
                if (!this.discard_own_messages || this.local_addr == null || msg.getSrc() == null || !this.local_addr.equals(msg.getSrc())) break;
                return null;
            }
            case 6: {
                View tmp = (View)evt.getArg();
                this.my_view = tmp instanceof MergeView ? new View(tmp.getViewId(), tmp.getMembers()) : tmp;
                if (this.state == Channel.State.CONNECTED) break;
                this.state = Channel.State.CONNECTED;
                break;
            }
            case 56: {
                Map cfg = (Map)evt.getArg();
                if (cfg == null) break;
                if (cfg.containsKey("state_transfer")) {
                    this.state_transfer_supported = (Boolean)cfg.get("state_transfer");
                }
                if (cfg.containsKey("flush_supported")) {
                    this.flush_supported = (Boolean)cfg.get("flush_supported");
                }
                cfg.putAll(cfg);
                break;
            }
            case 20: {
                StateTransferResult result = (StateTransferResult)evt.getArg();
                if (this.up_handler != null) {
                    try {
                        Object retval = this.up_handler.up(evt);
                        this.state_promise.setResult(new StateTransferResult());
                        return retval;
                    }
                    catch (Throwable t) {
                        this.state_promise.setResult(new StateTransferResult(t));
                    }
                }
                if (this.receiver == null) break;
                try {
                    if (result.hasBuffer()) {
                        byte[] tmp_state = result.getBuffer();
                        ByteArrayInputStream input = new ByteArrayInputStream(tmp_state);
                        this.receiver.setState(input);
                    }
                    this.state_promise.setResult(result);
                }
                catch (Throwable t) {
                    this.state_promise.setResult(new StateTransferResult(t));
                }
                break;
            }
            case 73: {
                this.state_promise.setResult((StateTransferResult)evt.getArg());
                break;
            }
            case 71: {
                if (this.up_handler != null) {
                    return this.up_handler.up(evt);
                }
                InputStream is = (InputStream)evt.getArg();
                if (is == null || this.receiver == null) break;
                try {
                    this.receiver.setState(is);
                    break;
                }
                catch (Throwable t) {
                    throw new RuntimeException("failed calling setState() in state requester", t);
                }
            }
            case 72: {
                if (this.receiver == null || evt.getArg() == null) break;
                try {
                    this.receiver.getState((OutputStream)evt.getArg());
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("failed calling getState() in state provider", e);
                }
            }
            case 91: {
                return this.local_addr;
            }
        }
        if (this.up_handler != null) {
            return this.up_handler.up(evt);
        }
        if (this.receiver != null) {
            return this.invokeCallback(evt.getType(), evt.getArg());
        }
        return null;
    }

    public void up(MessageBatch batch) {
        if (this.stats) {
            this.received_msgs += (long)batch.size();
            this.received_bytes += (long)batch.length();
        }
        if (this.discard_own_messages && this.local_addr != null && batch.sender() != null && this.local_addr.equals(batch.sender())) {
            return;
        }
        for (Message msg : batch) {
            if (this.up_handler != null) {
                try {
                    this.up_handler.up(new Event(1, msg));
                }
                catch (Throwable t) {
                    this.log.error(Util.getMessage("UpHandlerFailure"), t);
                }
                continue;
            }
            if (this.receiver == null) continue;
            try {
                this.receiver.receive(msg);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("ReceiverFailure"), t);
            }
        }
    }

    @Override
    public Object down(Event evt) {
        if (evt == null) {
            return null;
        }
        if (this.stats && evt.getType() == 1) {
            ++this.sent_msgs;
            this.sent_bytes += (long)((Message)evt.getArg()).getLength();
        }
        return this.prot_stack.down(evt);
    }

    @ManagedOperation
    public String toString(boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append("local_addr=").append(this.local_addr).append('\n');
        sb.append("cluster_name=").append(this.cluster_name).append('\n');
        sb.append("my_view=").append(this.my_view).append('\n');
        sb.append("state=").append((Object)this.state).append('\n');
        if (details) {
            sb.append("discard_own_messages=").append(this.discard_own_messages).append('\n');
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append('\n');
            sb.append("props=").append(this.getProperties()).append('\n');
        }
        return sb.toString();
    }

    protected Object invokeCallback(int type, Object arg) {
        switch (type) {
            case 1: {
                this.receiver.receive((Message)arg);
                break;
            }
            case 6: {
                this.receiver.viewAccepted((View)arg);
                break;
            }
            case 9: {
                this.receiver.suspect((Address)arg);
                break;
            }
            case 17: {
                byte[] tmp_state = null;
                if (this.receiver != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                    try {
                        this.receiver.getState(output);
                        tmp_state = output.toByteArray();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(this.local_addr + ": failed getting state from application", e);
                    }
                }
                return new StateTransferInfo(null, 0L, tmp_state);
            }
            case 10: {
                this.receiver.block();
                return true;
            }
            case 75: {
                this.receiver.unblock();
            }
        }
        return null;
    }

    protected final void init(ProtocolStackConfigurator configurator) throws Exception {
        List<ProtocolConfiguration> configs = configurator.getProtocolStack();
        for (ProtocolConfiguration config : configs) {
            config.substituteVariables();
        }
        this.prot_stack = new ProtocolStack(this);
        this.prot_stack.setup(configs);
    }

    protected final void init(JChannel ch) throws Exception {
        if (ch == null) {
            throw new IllegalArgumentException("channel is null");
        }
        this.prot_stack = new ProtocolStack(this);
        this.prot_stack.setup(ch.getProtocolStack());
    }

    protected void init() {
        if (this.local_addr != null) {
            this.down(new Event(90, this.local_addr));
        }
        this.local_addr = null;
        this.cluster_name = null;
        this.my_view = null;
    }

    protected void startStack(String cluster_name) throws Exception {
        this.checkClosed();
        if (cluster_name == null) {
            this.log.debug("cluster_name is null, assuming unicast channel");
        } else {
            this.cluster_name = cluster_name;
        }
        if (this.socket_factory != null) {
            this.prot_stack.getTopProtocol().setSocketFactory(this.socket_factory);
        }
        this.prot_stack.startStack(cluster_name, this.local_addr);
        ArrayList<Address> t = new ArrayList<Address>(1);
        t.add(this.local_addr);
        this.my_view = new View(this.local_addr, 0L, t);
        TP transport = this.prot_stack.getTransport();
        transport.registerProbeHandler(this.probe_handler);
    }

    protected void setAddress() {
        Address old_addr = this.local_addr;
        this.local_addr = this.generateAddress();
        if (old_addr != null) {
            this.down(new Event(90, old_addr));
        }
        if (this.name == null || this.name.isEmpty()) {
            this.name = Util.generateLocalName();
        }
        if (this.name != null && !this.name.isEmpty()) {
            UUID.add(this.local_addr, this.name);
        }
        Event evt = new Event(8, this.local_addr);
        this.down(evt);
        if (this.up_handler != null) {
            this.up_handler.up(evt);
        }
    }

    protected Address generateAddress() {
        int i;
        if (this.address_generators == null || this.address_generators.isEmpty()) {
            return UUID.randomUUID();
        }
        if (this.address_generators.size() == 1) {
            return this.address_generators.get(0).generateAddress();
        }
        Address[] addrs = new Address[this.address_generators.size()];
        for (i = 0; i < addrs.length; ++i) {
            addrs[i] = this.address_generators.get(i).generateAddress();
        }
        for (i = 0; i < addrs.length; ++i) {
            if (addrs[i] instanceof ExtendedUUID) continue;
            this.log.error("address generator %s does not subclass %s which is required if multiple address generators are installed, removing it", addrs[i].getClass().getSimpleName(), ExtendedUUID.class.getSimpleName());
            addrs[i] = null;
        }
        UUID uuid = null;
        for (int i2 = 0; i2 < addrs.length; ++i2) {
            if (addrs[i2] == null) continue;
            if (uuid == null) {
                uuid = (ExtendedUUID)addrs[i2];
                continue;
            }
            ((ExtendedUUID)uuid).addContents((ExtendedUUID)addrs[i2]);
        }
        return uuid != null ? uuid : UUID.randomUUID();
    }

    protected void checkClosed() {
        if (this.state == Channel.State.CLOSED) {
            throw new IllegalStateException("channel is closed");
        }
    }

    protected void checkClosedOrNotConnected() {
        if (this.state == Channel.State.CLOSED) {
            throw new IllegalStateException("channel is closed");
        }
        if (this.state != Channel.State.CONNECTING && this.state != Channel.State.CONNECTED) {
            throw new IllegalStateException("channel is disconnected");
        }
    }

    protected void _close(boolean disconnect) {
        Address old_addr = this.local_addr;
        if (this.state == Channel.State.CLOSED) {
            return;
        }
        if (disconnect) {
            this.disconnect();
        }
        this.stopStack(true, true);
        this.state = Channel.State.CLOSED;
        this.notifyChannelClosed(this);
        this.init();
        if (old_addr != null) {
            UUID.remove(old_addr);
        }
    }

    protected void stopStack(boolean stop, boolean destroy) {
        if (this.prot_stack != null) {
            try {
                if (stop) {
                    this.prot_stack.stopStack(this.cluster_name);
                }
                if (destroy) {
                    this.prot_stack.destroy();
                }
            }
            catch (Exception e) {
                this.log.error(Util.getMessage("StackDestroyFailure"), e);
            }
            TP transport = this.prot_stack.getTransport();
            if (transport != null) {
                transport.unregisterProbeHandler(this.probe_handler);
            }
        }
    }

    @Override
    public boolean flushSupported() {
        return this.flush_supported;
    }

    @Override
    public void startFlush(boolean automatic_resume) throws Exception {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        try {
            this.down(new Event(68));
        }
        catch (Exception e) {
            throw new Exception("Flush failed", e.getCause());
        }
        finally {
            if (automatic_resume) {
                this.stopFlush();
            }
        }
    }

    @Override
    public void startFlush(List<Address> flushParticipants, boolean automatic_resume) throws Exception {
        boolean validParticipants;
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        View v = this.getView();
        boolean bl = validParticipants = v != null && v.getMembers().containsAll(flushParticipants);
        if (!validParticipants) {
            throw new IllegalArgumentException("Current view " + v + " does not contain all flush participants " + flushParticipants);
        }
        try {
            this.down(new Event(68, flushParticipants));
        }
        catch (Exception e) {
            throw new Exception("Flush failed", e.getCause());
        }
        finally {
            if (automatic_resume) {
                this.stopFlush(flushParticipants);
            }
        }
    }

    @Override
    public void stopFlush() {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.down(new Event(70));
    }

    @Override
    public void stopFlush(List<Address> flushParticipants) {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.down(new Event(70, flushParticipants));
    }

    Address determineCoordinator() {
        List<Address> mbrs;
        List<Address> list = mbrs = this.my_view != null ? this.my_view.getMembers() : null;
        if (mbrs == null) {
            return null;
        }
        if (!mbrs.isEmpty()) {
            return mbrs.iterator().next();
        }
        return null;
    }

    protected TimeScheduler getTimer() {
        TP transport;
        if (this.prot_stack != null && (transport = this.prot_stack.getTransport()) != null) {
            return transport.getTimer();
        }
        return null;
    }

    class MyProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        MyProbeHandler() {
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            for (String key : keys) {
                int index;
                if (key.startsWith("jmx")) {
                    this.handleJmx(map, key);
                    continue;
                }
                if (key.startsWith("reset-stats")) {
                    this.resetAllStats();
                    continue;
                }
                if (!key.startsWith("invoke") && !key.startsWith("op") || (index = key.indexOf("=")) == -1) continue;
                try {
                    this.handleOperation(map, key.substring(index + 1));
                }
                catch (Throwable throwable) {
                    JChannel.this.log.error(Util.getMessage("OperationInvocationFailure"), key.substring(index + 1), throwable);
                }
            }
            map.put("version", "3.6.3.Final");
            if (JChannel.this.my_view != null && !map.containsKey("view")) {
                map.put("view", JChannel.this.my_view.toString());
            }
            map.put("local_addr", JChannel.this.getAddressAsString() + " [" + JChannel.this.getAddressAsUUID() + "]");
            PhysicalAddress physical_addr = (PhysicalAddress)JChannel.this.down(new Event(87, JChannel.this.local_addr));
            if (physical_addr != null) {
                map.put("physical_addr", physical_addr.toString());
            }
            map.put("cluster", JChannel.this.getClusterName());
            return map;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"reset-stats", "jmx", "invoke=<operation>[<args>]", "\nop=<operation>[<args>]"};
        }

        protected void resetAllStats() {
            List<Protocol> prots = JChannel.this.getProtocolStack().getProtocols();
            for (Protocol prot : prots) {
                prot.resetStatistics();
            }
            JChannel.this.resetStats();
        }

        protected void handleJmx(Map<String, String> map, String input) {
            block13: {
                block12: {
                    Map<String, Object> tmp_stats;
                    int index = input.indexOf("=");
                    if (index <= -1) break block12;
                    List<String> list = null;
                    String protocol_name = input.substring(index + 1);
                    if ((index = protocol_name.indexOf(".")) > -1) {
                        String rest = protocol_name;
                        protocol_name = protocol_name.substring(0, index);
                        String attrs = rest.substring(index + 1);
                        list = Util.parseStringList(attrs, ",");
                        Iterator<String> it = list.iterator();
                        while (it.hasNext()) {
                            Field field;
                            String tmp = it.next();
                            index = tmp.indexOf("=");
                            if (index == -1) continue;
                            String attrname = tmp.substring(0, index);
                            String attrvalue = tmp.substring(index + 1);
                            Protocol prot = JChannel.this.prot_stack.findProtocol(protocol_name);
                            Field field2 = field = prot != null ? Util.getField(prot.getClass(), attrname) : null;
                            if (field != null) {
                                Object value = MethodCall.convert(attrvalue, field.getType());
                                if (value != null) {
                                    prot.setValue(attrname, value);
                                }
                            } else {
                                ResourceDMBean.Accessor setter = ResourceDMBean.findSetter(prot, attrname);
                                if (setter != null) {
                                    try {
                                        Class<?> type = setter instanceof ResourceDMBean.FieldAccessor ? ((ResourceDMBean.FieldAccessor)setter).getField().getType() : (setter instanceof ResourceDMBean.MethodAccessor ? ((ResourceDMBean.MethodAccessor)setter).getMethod().getParameterTypes()[0].getClass() : null);
                                        Object converted_value = MethodCall.convert(attrvalue, type);
                                        setter.invoke(converted_value);
                                    }
                                    catch (Exception e) {
                                        JChannel.this.log.error("unable to invoke %s() on %s: %s", setter, protocol_name, e);
                                    }
                                } else {
                                    JChannel.this.log.warn(Util.getMessage("FieldNotFound"), attrname, protocol_name);
                                }
                            }
                            it.remove();
                        }
                    }
                    if ((tmp_stats = JChannel.this.dumpStats(protocol_name, list)) == null) break block13;
                    for (Map.Entry<String, Object> entry : tmp_stats.entrySet()) {
                        Map tmp_map = (Map)entry.getValue();
                        String key = entry.getKey();
                        map.put(key, tmp_map != null ? tmp_map.toString() : null);
                    }
                    break block13;
                }
                Map<String, Object> tmp_stats = JChannel.this.dumpStats();
                if (tmp_stats != null) {
                    for (Map.Entry<String, Object> entry : tmp_stats.entrySet()) {
                        Map tmp_map = (Map)entry.getValue();
                        String key = entry.getKey();
                        map.put(key, tmp_map != null ? tmp_map.toString() : null);
                    }
                }
            }
        }

        protected void handleOperation(Map<String, String> map, String operation) throws Exception {
            Object retval;
            Method method;
            int index = operation.indexOf(".");
            if (index == -1) {
                throw new IllegalArgumentException("operation " + operation + " is missing the protocol name");
            }
            String prot_name = operation.substring(0, index);
            Protocol prot = JChannel.this.prot_stack.findProtocol(prot_name);
            if (prot == null) {
                return;
            }
            int args_index = operation.indexOf("[");
            String method_name = args_index != -1 ? operation.substring(index + 1, args_index).trim() : operation.substring(index + 1).trim();
            String[] args = null;
            if (args_index != -1) {
                int end_index = operation.indexOf("]");
                if (end_index == -1) {
                    throw new IllegalArgumentException("] not found");
                }
                List<String> str_args = Util.parseCommaDelimitedStrings(operation.substring(args_index + 1, end_index));
                Object[] strings = str_args.toArray();
                args = new String[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    args[i] = (String)strings[i];
                }
            }
            if ((method = MethodCall.findMethod(prot.getClass(), method_name, args)) == null) {
                JChannel.this.log.warn(Util.getMessage("MethodNotFound"), JChannel.this.local_addr, prot.getClass().getSimpleName(), method_name);
                return;
            }
            MethodCall call = new MethodCall(method);
            Object[] converted_args = null;
            if (args != null) {
                converted_args = new Object[args.length];
                Class<?>[] types = method.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    converted_args[i] = MethodCall.convert(args[i], types[i]);
                }
            }
            if ((retval = call.invoke(prot, converted_args)) != null) {
                map.put(prot_name + "." + method_name, retval.toString());
            }
        }
    }
}

