/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class HornetQThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final int threadPriority;
    private final boolean daemon;
    private final ClassLoader tccl;

    public HornetQThreadFactory(String groupName, boolean daemon, ClassLoader tccl) {
        this.group = new ThreadGroup(groupName + "-" + System.identityHashCode(this));
        this.threadPriority = 5;
        this.tccl = tccl;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(final Runnable command) {
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread t = new Thread(HornetQThreadFactory.this.group, command, "Thread-" + HornetQThreadFactory.this.threadCount.getAndIncrement() + " (" + HornetQThreadFactory.this.group.getName() + ")");
                t.setDaemon(HornetQThreadFactory.this.daemon);
                t.setPriority(HornetQThreadFactory.this.threadPriority);
                t.setContextClassLoader(HornetQThreadFactory.this.tccl);
                return t;
            }
        });
    }
}

