/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.security.AccessController;
import java.util.HashMap;
import java.util.ServiceLoader;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.HashProcessor;
import org.apache.activemq.artemis.utils.NoHashProcessor;
import org.apache.activemq.artemis.utils.SecureHashProcessor;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;

public final class PasswordMaskingUtil {
    public static final String BEGIN_ENC = "ENC(";
    public static final String END_ENC = ")";

    private PasswordMaskingUtil() {
    }

    public static String resolveMask(Boolean maskPassword, String password, String codecClass) throws Exception {
        String plainText = password;
        if (maskPassword == null) {
            if (PasswordMaskingUtil.isEncMasked(password)) {
                String bareMaskedPassword = PasswordMaskingUtil.unwrap(password);
                plainText = PasswordMaskingUtil.getCodec(codecClass).decode(bareMaskedPassword);
            }
        } else if (maskPassword.booleanValue()) {
            plainText = PasswordMaskingUtil.getCodec(codecClass).decode(password);
        }
        return plainText;
    }

    public static boolean isEncMasked(String password) {
        return password.startsWith(BEGIN_ENC) && password.endsWith(END_ENC);
    }

    public static String unwrap(String password) {
        return password.substring(4, password.length() - 1);
    }

    public static String wrap(String password) {
        return BEGIN_ENC + password + END_ENC;
    }

    public static HashProcessor getHashProcessor(String storedPassword) throws Exception {
        if (!PasswordMaskingUtil.isEncoded(storedPassword)) {
            return LazyPlainTextProcessorHolder.INSTANCE;
        }
        Exception secureProcessorException = LazySecureProcessorHolder.EXCEPTION;
        if (secureProcessorException != null) {
            throw new RuntimeException(secureProcessorException);
        }
        return LazySecureProcessorHolder.INSTANCE;
    }

    private static boolean isEncoded(String storedPassword) {
        return storedPassword == null || PasswordMaskingUtil.isEncMasked(storedPassword);
    }

    public static HashProcessor getHashProcessor() {
        HashProcessor processor = LazySecureProcessorHolder.INSTANCE;
        if (processor == null) {
            processor = LazyPlainTextProcessorHolder.INSTANCE;
        }
        return processor;
    }

    public static SensitiveDataCodec<String> getCodec(String codecDesc) throws ActiveMQException {
        if (codecDesc == null) {
            return PasswordMaskingUtil.getDefaultCodec();
        }
        String[] parts = codecDesc.split(";");
        if (parts.length < 1) {
            throw new ActiveMQException(ActiveMQExceptionType.ILLEGAL_STATE, "Invalid PasswordCodec value: " + codecDesc);
        }
        String codecClassName = parts[0];
        SensitiveDataCodec codecInstance = AccessController.doPrivileged(() -> {
            ServiceLoader<SensitiveDataCodec> serviceLoader = ServiceLoader.load(SensitiveDataCodec.class, PasswordMaskingUtil.class.getClassLoader());
            try {
                for (SensitiveDataCodec codec : serviceLoader) {
                    if (!codec.getClass().getCanonicalName().equals(codecClassName)) continue;
                    return (SensitiveDataCodec)codec.getClass().newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                return (SensitiveDataCodec)PasswordMaskingUtil.class.getClassLoader().loadClass(codecClassName).newInstance();
            }
            catch (Exception e) {
                try {
                    return (SensitiveDataCodec)Thread.currentThread().getContextClassLoader().loadClass(codecClassName).newInstance();
                }
                catch (Exception e2) {
                    throw ActiveMQUtilBundle.BUNDLE.errorCreatingCodec(e2, codecClassName);
                }
            }
        });
        if (parts.length > 1) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (int i = 1; i < parts.length; ++i) {
                String[] keyVal = parts[i].split("=");
                if (keyVal.length != 2) {
                    throw ActiveMQUtilBundle.BUNDLE.invalidProperty(parts[i]);
                }
                props.put(keyVal[0], keyVal[1]);
            }
            try {
                codecInstance.init(props);
            }
            catch (Exception e) {
                throw new ActiveMQException("Fail to init codec", e, ActiveMQExceptionType.SECURITY_EXCEPTION);
            }
        }
        return codecInstance;
    }

    public static DefaultSensitiveStringCodec getDefaultCodec() {
        return new DefaultSensitiveStringCodec();
    }

    private static final class LazySecureProcessorHolder {
        private static final HashProcessor INSTANCE;
        private static final Exception EXCEPTION;

        private LazySecureProcessorHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            SecureHashProcessor processor = null;
            Exception exception = null;
            String codecDesc = DefaultSensitiveStringCodec.class.getName() + ";" + "algorithm" + "=" + "one-way";
            try {
                DefaultSensitiveStringCodec codec = (DefaultSensitiveStringCodec)PasswordMaskingUtil.getCodec(codecDesc);
                processor = new SecureHashProcessor(codec);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                EXCEPTION = exception;
                INSTANCE = processor;
            }
        }
    }

    private static final class LazyPlainTextProcessorHolder {
        private static final HashProcessor INSTANCE = new NoHashProcessor();

        private LazyPlainTextProcessorHolder() {
        }
    }
}

