/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Tuple;

public abstract class KeyExchange
extends Protocol {
    protected Address local_addr;

    @Override
    public List<Integer> providedUpServices() {
        return Collections.singletonList(110);
    }

    @Override
    public List<Integer> requiredUpServices() {
        return Arrays.asList(111, 112);
    }

    public abstract void fetchSecretKeyFrom(Address var1) throws Exception;

    @Override
    public Object down(Event evt) {
        switch (evt.type()) {
            case 8: {
                this.local_addr = (Address)evt.arg();
                break;
            }
            case 6: {
                this.handleView((View)evt.arg());
                break;
            }
            case 110: {
                Address target = (Address)evt.arg();
                try {
                    this.fetchSecretKeyFrom(target);
                }
                catch (Exception e) {
                    this.log.warn("failed fetching secret key from %s: %s", target, e);
                }
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    protected void handleView(View view) {
    }

    protected Tuple<SecretKey, byte[]> getSecretKeyFromAbove() {
        return (Tuple)this.up_prot.up(new Event(111));
    }

    protected void setSecretKeyAbove(Tuple<SecretKey, byte[]> key) {
        this.up_prot.up(new Event(112, key));
    }

    protected <T extends Protocol> T findProtocolAbove(Class<? extends Protocol> clazz) {
        for (KeyExchange tmp = this; tmp != null; tmp = tmp.getUpProtocol()) {
            Class<?> protClass = tmp.getClass();
            if (!clazz.isAssignableFrom(protClass)) continue;
            return (T)tmp;
        }
        return null;
    }
}

