/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.io.Serializable;
import java.net.URI;
import java.util.List;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.transaction.client.RemoteTransactionContext;

final class SerializedUserTransaction
implements Serializable {
    private static final long serialVersionUID = -7197250436320616251L;
    private final URI location;

    SerializedUserTransaction(URI location) {
        this.location = location;
    }

    Object readResolve() {
        NamingProvider currentNamingProvider = NamingProvider.getCurrentNamingProvider();
        if (currentNamingProvider != null) {
            List<NamingProvider.Location> locations = currentNamingProvider.getLocations();
            for (NamingProvider.Location location : locations) {
                URI providerUri = location.getUri();
                if (!providerUri.equals(this.location)) continue;
                return RemoteTransactionContext.getInstancePrivate().getUserTransaction(providerUri, location.getSSLContext(), location.getAuthenticationConfiguration());
            }
        }
        return RemoteTransactionContext.getInstancePrivate().getUserTransaction(this.location);
    }
}

