/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacket;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public class SessionSendMessage
extends MessagePacket {
    private boolean requiresResponse;
    private final transient SendAcknowledgementHandler handler;

    public SessionSendMessage(MessageInternal message, boolean requiresResponse, SendAcknowledgementHandler handler) {
        super((byte)71, message);
        this.handler = handler;
        this.requiresResponse = requiresResponse;
    }

    public SessionSendMessage(MessageInternal message) {
        super((byte)71, message);
        this.handler = null;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public SendAcknowledgementHandler getHandler() {
        return this.handler;
    }

    @Override
    public ActiveMQBuffer encode(RemotingConnection connection) {
        ActiveMQBuffer buffer = this.message.getEncodedBuffer();
        ActiveMQBuffer bufferWrite = connection == null ? buffer.copy(0, buffer.capacity()) : connection.createTransportBuffer(buffer.writerIndex() + 1, true);
        bufferWrite.writeBytes(buffer, 0, buffer.writerIndex());
        bufferWrite.setIndex(buffer.readerIndex(), buffer.writerIndex());
        if (bufferWrite.writerIndex() != this.message.getEndOfMessagePosition()) {
            throw new IllegalStateException("Wrong encode position");
        }
        bufferWrite.writeBoolean(this.requiresResponse);
        this.size = bufferWrite.writerIndex();
        int len = this.size - 4;
        bufferWrite.setInt(0, len);
        bufferWrite.setByte(4, this.getType());
        bufferWrite.setLong(5, this.channelID);
        bufferWrite.readerIndex(0);
        return bufferWrite;
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.message.decodeFromBuffer(buffer);
        int ri = buffer.readerIndex();
        this.requiresResponse = buffer.readBoolean();
        buffer.readerIndex(ri);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", requiresResponse=" + this.requiresResponse);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendMessage)) {
            return false;
        }
        SessionSendMessage other = (SessionSendMessage)obj;
        return this.requiresResponse == other.requiresResponse;
    }
}

