/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client;

import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.w3c.dom.Node;

public class ActiveMQClientLogger_$logger
extends DelegatingBasicLogger
implements ActiveMQClientLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQClientLogger_$logger.class.getName();
    private static final String dumpingSessionStacks = "AMQ211000: **** Dumping session creation stacks ****";
    private static final String dumpingSessionStack = "AMQ211001: session created";
    private static final String warn = "AMQ212000: {0}";
    private static final String errorClearingMessages = "AMQ212001: Error on clearing messages";
    private static final String timeOutWaitingForProcessing = "AMQ212002: Timed out waiting for handler to complete processing";
    private static final String unableToCloseSession = "AMQ212003: Unable to close session";
    private static final String failedToConnectToServer0 = "AMQ212004: Failed to connect to server.";
    private static final String failedToConnectToServer1 = "AMQ212005: Tried {0} times to connect. Now giving up on reconnecting it.";
    private static final String createConnectorException = "AMQ212007: connector.create or connectorFactory.createConnector should never throw an exception, implementation is badly behaved, but we will deal with it anyway.";
    private static final String factoryLeftOpen = "AMQ212008: I am closing a core ClientSessionFactory you left open. Please make sure you close all ClientSessionFactories explicitly before letting them go out of scope! {0}";
    private static final String resettingSessionAfterFailure = "AMQ212009: resetting session after failure";
    private static final String retryCreateSessionSeverStarting = "AMQ212010: Server is starting, retry to create the session {0}";
    private static final String commitAfterFailover = "AMQ212011: committing transaction after failover occurred, any non persistent messages may be lost";
    private static final String failoverDuringCommit = "AMQ212012: failure occurred during commit throwing XAException";
    private static final String failoverDuringPrepareRollingBack = "AMQ212014: failover occurred during prepare rolling back";
    private static final String errorDuringPrepare = "AMQ212015: failover occurred during prepare rolling back";
    private static final String clientSessionNotClosed = "AMQ212016: I am closing a core ClientSession you left open. Please make sure you close all ClientSessions explicitly before letting them go out of scope! {0}";
    private static final String errorAddingPacket = "AMQ212017: error adding packet";
    private static final String errorCallingCancel = "AMQ212018: error calling cancel";
    private static final String errorReadingIndex = "AMQ212019: error reading index";
    private static final String errorSettingIndex = "AMQ212020: error setting index";
    private static final String errorReSettingIndex = "AMQ212021: error resetting index";
    private static final String errorReadingCache = "AMQ212022: error reading LargeMessage file cache";
    private static final String errorClosingCache = "AMQ212023: error closing LargeMessage file cache";
    private static final String errorFinalisingCache = "AMQ212024: Exception during finalization for LargeMessage file cache";
    private static final String errorConnectingToNodes = "AMQ212025: did not connect the cluster connection to other nodes";
    private static final String timedOutWaitingForTermination = "AMQ212026: Timed out waiting for pool to terminate";
    private static final String timedOutWaitingForScheduledPoolTermination = "AMQ212027: Timed out waiting for scheduled pool to terminate";
    private static final String errorStartingLocator = "AMQ212028: error starting server locator";
    private static final String serverLocatorNotClosed = "AMQ212029: Closing a Server Locator left open. Please make sure you close all Server Locators explicitly before letting them go out of scope! {0}";
    private static final String errorSendingTopology = "AMQ212030: error sending topology";
    private static final String errorSendingTopologyNodedown = "AMQ212031: error sending topology";
    private static final String timedOutStoppingDiscovery = "AMQ212032: Timed out waiting to stop discovery thread";
    private static final String errorSendingNotifOnDiscoveryStop = "AMQ212033: unable to send notification when discovery group is stopped";
    private static final String multipleServersBroadcastingSameNode = "AMQ212034: There are more than one servers on the network broadcasting the same node id. You will see this message exactly once (per node) if a node is restarted, in which case it can be safely ignored. But if it is logged continuously it means you really do have more than one node on the same network active concurrently with the same node id. This could occur if you have a backup node active at the same time as its live node. nodeID={0}";
    private static final String errorReceivingPacketInDiscovery = "AMQ212035: error receiving packet in discovery";
    private static final String cannotFindPacketToClear = "AMQ212036: Can not find packet to clear: {0} last received command id first stored command id {1}";
    private static final String connectionFailureDetected = "AMQ212037: Connection failure has been detected: {0} [code={1}]";
    private static final String errorCallingInterceptor = "AMQ212038: Failure in calling interceptor: {0}";
    private static final String timeoutClosingSSL = "AMQ212040: Timed out waiting for netty ssl close future to complete";
    private static final String timeoutClosingNettyChannel = "AMQ212041: Timed out waiting for netty channel to close";
    private static final String timeoutFlushingPacket = "AMQ212042: Timed out waiting for packet to be flushed";
    private static final String propertyNotInteger = "AMQ212043: Property {0} must be an Integer, it is {1}";
    private static final String propertyNotLong = "AMQ212044: Property {0} must be a Long, it is {1}";
    private static final String propertyNotBoolean = "AMQ212045: Property {0} must be a Boolean, it is {1}";
    private static final String noVersionOnClasspath = "AMQ212046: Cannot find activemq-version.properties on classpath: {0}";
    private static final String jvmAllocatedMoreMemory = "AMQ212047: Warning: JVM allocated more data what would make results invalid {0}:{1}";
    private static final String broadcastGroupBindErrorRetry = "AMQ212048: Random address ({0}) was already in use, trying another time";
    private static final String ioDiscoveryError = "AMQ212049: Could not bind to {0} ({1} address); make sure your discovery group-address is of the same type as the IP stack (IPv4 or IPv6).\nIgnoring discovery group-address, but this may lead to cross talking.";
    private static final String compressedLargeMessageError = "AMQ212050: Compressed large message tried to read {0} bytes from stream {1}";
    private static final String invalidConcurrentSessionUsage = "AMQ212051: Invalid concurrent session usage. Sessions are not supposed to be used by more than one thread concurrently.";
    private static final String packetOutOfOrder = "AMQ212052: Packet {0} was answered out of sequence due to a previous server timeout and it''s being ignored";
    private static final String confirmationWindowDisabledWarning = "AMQ212053: CompletionListener/SendAcknowledgementHandler used with confirmationWindowSize=-1. Enable confirmationWindowSize to receive acks from server!";
    private static final String outOfCreditOnFlowControl = "AMQ212054: Destination address={0} is blocked. If the system is configured to block make sure you consume messages on this configuration.";
    private static final String unableToCloseConsumer = "AMQ212055: Unable to close consumer";
    private static final String broadcastGroupBindError = "AMQ212056: local-bind-address specified for broadcast group but no local-bind-port. Using random port for UDP Broadcast ({0})";
    private static final String onMessageError = "AMQ214000: Failed to call onMessage";
    private static final String failedToCleanupSession = "AMQ214001: failed to cleanup session";
    private static final String failedToExecuteListener = "AMQ214002: Failed to execute failure listener";
    private static final String failedToHandleFailover = "AMQ214003: Failed to handle failover";
    private static final String errorCallingEnd = "AMQ214004: XA end operation failed ";
    private static final String errorCallingStart = "AMQ214005: XA start operation failed {0} code:{1}";
    private static final String sessionNotXA = "AMQ214006: Session is not XA";
    private static final String receivedExceptionAsynchronously = "AMQ214007: Received exception asynchronously from server";
    private static final String failedToHandlePacket = "AMQ214008: Failed to handle packet";
    private static final String failedToStopDiscovery = "AMQ214009: Failed to stop discovery group";
    private static final String failedToReceiveDatagramInDiscovery = "AMQ214010: Failed to receive datagram";
    private static final String failedToCallListenerInDiscovery = "AMQ214011: Failed to call discovery listener";
    private static final String errorHandlingPacket = "AMQ214012: Unexpected error handling packet {0}";
    private static final String errorDecodingPacket = "AMQ214013: Failed to decode packet";
    private static final String errorCallingFailureListener = "AMQ214014: Failed to execute failure listener";
    private static final String errorCallingLifeCycleListener = "AMQ214015: Failed to execute connection life cycle listener";
    private static final String errorCreatingNettyConnection = "AMQ214016: Failed to create netty connection";
    private static final String caughtunexpectedThrowable = "AMQ214017: Caught unexpected Throwable";
    private static final String errorOnXMLTransform = "AMQ214018: Failed to invoke getTextContent() on node {0}";
    private static final String errorOnXMLTransformInvalidConf = "AMQ214019: Invalid configuration";
    private static final String errorStoppingDiscoveryBroadcastEndpoint = "AMQ214020: Exception happened while stopping Discovery BroadcastEndpoint {0}";
    private static final String invalidCipherSuite = "AMQ214021: Invalid cipher suite specified. Supported cipher suites are: {0}";
    private static final String invalidProtocol = "AMQ214022: Invalid protocol specified. Supported protocols are: {0}";
    private static final String httpHandshakeFailed = "AMQ214023: HTTP Handshake failed, received %s";
    private static final String httpUpgradeNotSupportedByRemoteAcceptor = "AMQ214024: HTTP upgrade not supported by remote acceptor";
    private static final String invalidCFType = "AMQ214025: Invalid type {0}, Using default connection factory at {1}";
    private static final String failoverOrReconnect = "AMQ214026: Failure captured on connectionID={0}, performing failover or reconnection now";
    private static final String replayingCommands = "AMQ214027: Replaying commands for channelID={0} with lastCommandID from the server={1}";
    private static final String reconnectCreatingNewSession = "AMQ214028: Couldn't reattach session {0}, performing as a failover operation now and recreating objects";
    private static final String unexpectedResponseFromHttpServer = "AMQ214029: Unexpected response from HTTP server: %s";

    public ActiveMQClientLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void dumpingSessionStacks() {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.dumpingSessionStacks$str(), new Object[0]);
    }

    protected String dumpingSessionStacks$str() {
        return dumpingSessionStacks;
    }

    @Override
    public final void dumpingSessionStack(Exception e) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)e, this.dumpingSessionStack$str(), new Object[0]);
    }

    protected String dumpingSessionStack$str() {
        return dumpingSessionStack;
    }

    @Override
    public final void warn(String message) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.warn$str(), (Object)message);
    }

    protected String warn$str() {
        return warn;
    }

    @Override
    public final void errorClearingMessages(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorClearingMessages$str(), new Object[0]);
    }

    protected String errorClearingMessages$str() {
        return errorClearingMessages;
    }

    @Override
    public final void timeOutWaitingForProcessing() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timeOutWaitingForProcessing$str(), new Object[0]);
    }

    protected String timeOutWaitingForProcessing$str() {
        return timeOutWaitingForProcessing;
    }

    @Override
    public final void unableToCloseSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseSession$str(), new Object[0]);
    }

    protected String unableToCloseSession$str() {
        return unableToCloseSession;
    }

    @Override
    public final void failedToConnectToServer() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.failedToConnectToServer0$str(), new Object[0]);
    }

    protected String failedToConnectToServer0$str() {
        return failedToConnectToServer0;
    }

    @Override
    public final void failedToConnectToServer(Integer reconnectAttempts) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.failedToConnectToServer1$str(), (Object)reconnectAttempts);
    }

    protected String failedToConnectToServer1$str() {
        return failedToConnectToServer1;
    }

    @Override
    public final void createConnectorException(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.createConnectorException$str(), new Object[0]);
    }

    protected String createConnectorException$str() {
        return createConnectorException;
    }

    @Override
    public final void factoryLeftOpen(Exception e, int i) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.factoryLeftOpen$str(), (Object)i);
    }

    protected String factoryLeftOpen$str() {
        return factoryLeftOpen;
    }

    @Override
    public final void resettingSessionAfterFailure() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.resettingSessionAfterFailure$str(), new Object[0]);
    }

    protected String resettingSessionAfterFailure$str() {
        return resettingSessionAfterFailure;
    }

    @Override
    public final void retryCreateSessionSeverStarting(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.retryCreateSessionSeverStarting$str(), (Object)name);
    }

    protected String retryCreateSessionSeverStarting$str() {
        return retryCreateSessionSeverStarting;
    }

    @Override
    public final void commitAfterFailover() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.commitAfterFailover$str(), new Object[0]);
    }

    protected String commitAfterFailover$str() {
        return commitAfterFailover;
    }

    @Override
    public final void failoverDuringCommit() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.failoverDuringCommit$str(), new Object[0]);
    }

    protected String failoverDuringCommit$str() {
        return failoverDuringCommit;
    }

    @Override
    public final void failoverDuringPrepareRollingBack() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.failoverDuringPrepareRollingBack$str(), new Object[0]);
    }

    protected String failoverDuringPrepareRollingBack$str() {
        return failoverDuringPrepareRollingBack;
    }

    @Override
    public final void errorDuringPrepare(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorDuringPrepare$str(), new Object[0]);
    }

    protected String errorDuringPrepare$str() {
        return errorDuringPrepare;
    }

    @Override
    public final void clientSessionNotClosed(Exception e, int identity) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.clientSessionNotClosed$str(), (Object)identity);
    }

    protected String clientSessionNotClosed$str() {
        return clientSessionNotClosed;
    }

    @Override
    public final void errorAddingPacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorAddingPacket$str(), new Object[0]);
    }

    protected String errorAddingPacket$str() {
        return errorAddingPacket;
    }

    @Override
    public final void errorCallingCancel(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCallingCancel$str(), new Object[0]);
    }

    protected String errorCallingCancel$str() {
        return errorCallingCancel;
    }

    @Override
    public final void errorReadingIndex(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorReadingIndex$str(), new Object[0]);
    }

    protected String errorReadingIndex$str() {
        return errorReadingIndex;
    }

    @Override
    public final void errorSettingIndex(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorSettingIndex$str(), new Object[0]);
    }

    protected String errorSettingIndex$str() {
        return errorSettingIndex;
    }

    @Override
    public final void errorReSettingIndex(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorReSettingIndex$str(), new Object[0]);
    }

    protected String errorReSettingIndex$str() {
        return errorReSettingIndex;
    }

    @Override
    public final void errorReadingCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorReadingCache$str(), new Object[0]);
    }

    protected String errorReadingCache$str() {
        return errorReadingCache;
    }

    @Override
    public final void errorClosingCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingCache$str(), new Object[0]);
    }

    protected String errorClosingCache$str() {
        return errorClosingCache;
    }

    @Override
    public final void errorFinalisingCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorFinalisingCache$str(), new Object[0]);
    }

    protected String errorFinalisingCache$str() {
        return errorFinalisingCache;
    }

    @Override
    public final void errorConnectingToNodes(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorConnectingToNodes$str(), new Object[0]);
    }

    protected String errorConnectingToNodes$str() {
        return errorConnectingToNodes;
    }

    @Override
    public final void timedOutWaitingForTermination() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutWaitingForTermination$str(), new Object[0]);
    }

    protected String timedOutWaitingForTermination$str() {
        return timedOutWaitingForTermination;
    }

    @Override
    public final void timedOutWaitingForScheduledPoolTermination() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutWaitingForScheduledPoolTermination$str(), new Object[0]);
    }

    protected String timedOutWaitingForScheduledPoolTermination$str() {
        return timedOutWaitingForScheduledPoolTermination;
    }

    @Override
    public final void errorStartingLocator(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorStartingLocator$str(), new Object[0]);
    }

    protected String errorStartingLocator$str() {
        return errorStartingLocator;
    }

    @Override
    public final void serverLocatorNotClosed(Exception e, int identity) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)e, this.serverLocatorNotClosed$str(), (Object)identity);
    }

    protected String serverLocatorNotClosed$str() {
        return serverLocatorNotClosed;
    }

    @Override
    public final void errorSendingTopology(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorSendingTopology$str(), new Object[0]);
    }

    protected String errorSendingTopology$str() {
        return errorSendingTopology;
    }

    @Override
    public final void errorSendingTopologyNodedown(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorSendingTopologyNodedown$str(), new Object[0]);
    }

    protected String errorSendingTopologyNodedown$str() {
        return errorSendingTopologyNodedown;
    }

    @Override
    public final void timedOutStoppingDiscovery() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timedOutStoppingDiscovery$str(), new Object[0]);
    }

    protected String timedOutStoppingDiscovery$str() {
        return timedOutStoppingDiscovery;
    }

    @Override
    public final void errorSendingNotifOnDiscoveryStop(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorSendingNotifOnDiscoveryStop$str(), new Object[0]);
    }

    protected String errorSendingNotifOnDiscoveryStop$str() {
        return errorSendingNotifOnDiscoveryStop;
    }

    @Override
    public final void multipleServersBroadcastingSameNode(String nodeId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.multipleServersBroadcastingSameNode$str(), (Object)nodeId);
    }

    protected String multipleServersBroadcastingSameNode$str() {
        return multipleServersBroadcastingSameNode;
    }

    @Override
    public final void errorReceivingPacketInDiscovery(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorReceivingPacketInDiscovery$str(), new Object[0]);
    }

    protected String errorReceivingPacketInDiscovery$str() {
        return errorReceivingPacketInDiscovery;
    }

    @Override
    public final void cannotFindPacketToClear(Integer lastReceivedCommandID, Integer firstStoredCommandID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.cannotFindPacketToClear$str(), (Object)lastReceivedCommandID, (Object)firstStoredCommandID);
    }

    protected String cannotFindPacketToClear$str() {
        return cannotFindPacketToClear;
    }

    @Override
    public final void connectionFailureDetected(String message, ActiveMQExceptionType type) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.connectionFailureDetected$str(), (Object)message, (Object)type);
    }

    protected String connectionFailureDetected$str() {
        return connectionFailureDetected;
    }

    @Override
    public final void errorCallingInterceptor(Throwable e, Interceptor interceptor) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorCallingInterceptor$str(), (Object)interceptor);
    }

    protected String errorCallingInterceptor$str() {
        return errorCallingInterceptor;
    }

    @Override
    public final void timeoutClosingSSL() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timeoutClosingSSL$str(), new Object[0]);
    }

    protected String timeoutClosingSSL$str() {
        return timeoutClosingSSL;
    }

    @Override
    public final void timeoutClosingNettyChannel() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timeoutClosingNettyChannel$str(), new Object[0]);
    }

    protected String timeoutClosingNettyChannel$str() {
        return timeoutClosingNettyChannel;
    }

    @Override
    public final void timeoutFlushingPacket() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.timeoutFlushingPacket$str(), new Object[0]);
    }

    protected String timeoutFlushingPacket$str() {
        return timeoutFlushingPacket;
    }

    @Override
    public final void propertyNotInteger(String propName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.propertyNotInteger$str(), (Object)propName, (Object)name);
    }

    protected String propertyNotInteger$str() {
        return propertyNotInteger;
    }

    @Override
    public final void propertyNotLong(String propName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.propertyNotLong$str(), (Object)propName, (Object)name);
    }

    protected String propertyNotLong$str() {
        return propertyNotLong;
    }

    @Override
    public final void propertyNotBoolean(String propName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.propertyNotBoolean$str(), (Object)propName, (Object)name);
    }

    protected String propertyNotBoolean$str() {
        return propertyNotBoolean;
    }

    @Override
    public final void noVersionOnClasspath(String classpath) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noVersionOnClasspath$str(), (Object)classpath);
    }

    protected String noVersionOnClasspath$str() {
        return noVersionOnClasspath;
    }

    @Override
    public final void jvmAllocatedMoreMemory(Long totalMemory1, Long totalMemory2) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.jvmAllocatedMoreMemory$str(), (Object)totalMemory1, (Object)totalMemory2);
    }

    protected String jvmAllocatedMoreMemory$str() {
        return jvmAllocatedMoreMemory;
    }

    @Override
    public final void broadcastGroupBindErrorRetry(String hostAndPort, Throwable t) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.broadcastGroupBindErrorRetry$str(), (Object)hostAndPort);
    }

    protected String broadcastGroupBindErrorRetry$str() {
        return broadcastGroupBindErrorRetry;
    }

    @Override
    public final void ioDiscoveryError(String hostAddress, String s) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.ioDiscoveryError$str(), (Object)hostAddress, (Object)s);
    }

    protected String ioDiscoveryError$str() {
        return ioDiscoveryError;
    }

    @Override
    public final void compressedLargeMessageError(int length, int nReadBytes) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.compressedLargeMessageError$str(), (Object)length, (Object)nReadBytes);
    }

    protected String compressedLargeMessageError$str() {
        return compressedLargeMessageError;
    }

    @Override
    public final void invalidConcurrentSessionUsage(Throwable t) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.invalidConcurrentSessionUsage$str(), new Object[0]);
    }

    protected String invalidConcurrentSessionUsage$str() {
        return invalidConcurrentSessionUsage;
    }

    @Override
    public final void packetOutOfOrder(Object obj, Throwable t) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.packetOutOfOrder$str(), obj);
    }

    protected String packetOutOfOrder$str() {
        return packetOutOfOrder;
    }

    @Override
    public final void confirmationWindowDisabledWarning() {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.confirmationWindowDisabledWarning$str(), new Object[0]);
    }

    protected String confirmationWindowDisabledWarning$str() {
        return confirmationWindowDisabledWarning;
    }

    @Override
    public final void outOfCreditOnFlowControl(String address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.outOfCreditOnFlowControl$str(), (Object)address);
    }

    protected String outOfCreditOnFlowControl$str() {
        return outOfCreditOnFlowControl;
    }

    @Override
    public final void unableToCloseConsumer(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseConsumer$str(), new Object[0]);
    }

    protected String unableToCloseConsumer$str() {
        return unableToCloseConsumer;
    }

    @Override
    public final void broadcastGroupBindError(String hostAndPort) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.broadcastGroupBindError$str(), (Object)hostAndPort);
    }

    protected String broadcastGroupBindError$str() {
        return broadcastGroupBindError;
    }

    @Override
    public final void onMessageError(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.onMessageError$str(), new Object[0]);
    }

    protected String onMessageError$str() {
        return onMessageError;
    }

    @Override
    public final void failedToCleanupSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToCleanupSession$str(), new Object[0]);
    }

    protected String failedToCleanupSession$str() {
        return failedToCleanupSession;
    }

    @Override
    public final void failedToExecuteListener(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.failedToExecuteListener$str(), new Object[0]);
    }

    protected String failedToExecuteListener$str() {
        return failedToExecuteListener;
    }

    @Override
    public final void failedToHandleFailover(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.failedToHandleFailover$str(), new Object[0]);
    }

    protected String failedToHandleFailover$str() {
        return failedToHandleFailover;
    }

    @Override
    public final void errorCallingEnd(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorCallingEnd$str(), new Object[0]);
    }

    protected String errorCallingEnd$str() {
        return errorCallingEnd;
    }

    @Override
    public final void errorCallingStart(String message, Integer code) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.errorCallingStart$str(), (Object)message, (Object)code);
    }

    protected String errorCallingStart$str() {
        return errorCallingStart;
    }

    @Override
    public final void sessionNotXA() {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.sessionNotXA$str(), new Object[0]);
    }

    protected String sessionNotXA$str() {
        return sessionNotXA;
    }

    @Override
    public final void receivedExceptionAsynchronously(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.receivedExceptionAsynchronously$str(), new Object[0]);
    }

    protected String receivedExceptionAsynchronously$str() {
        return receivedExceptionAsynchronously;
    }

    @Override
    public final void failedToHandlePacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToHandlePacket$str(), new Object[0]);
    }

    protected String failedToHandlePacket$str() {
        return failedToHandlePacket;
    }

    @Override
    public final void failedToStopDiscovery(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.failedToStopDiscovery$str(), new Object[0]);
    }

    protected String failedToStopDiscovery$str() {
        return failedToStopDiscovery;
    }

    @Override
    public final void failedToReceiveDatagramInDiscovery(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.failedToReceiveDatagramInDiscovery$str(), new Object[0]);
    }

    protected String failedToReceiveDatagramInDiscovery$str() {
        return failedToReceiveDatagramInDiscovery;
    }

    @Override
    public final void failedToCallListenerInDiscovery(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.failedToCallListenerInDiscovery$str(), new Object[0]);
    }

    protected String failedToCallListenerInDiscovery$str() {
        return failedToCallListenerInDiscovery;
    }

    @Override
    public final void errorHandlingPacket(Throwable t, Packet packet) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorHandlingPacket$str(), (Object)packet);
    }

    protected String errorHandlingPacket$str() {
        return errorHandlingPacket;
    }

    @Override
    public final void errorDecodingPacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorDecodingPacket$str(), new Object[0]);
    }

    protected String errorDecodingPacket$str() {
        return errorDecodingPacket;
    }

    @Override
    public final void errorCallingFailureListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorCallingFailureListener$str(), new Object[0]);
    }

    protected String errorCallingFailureListener$str() {
        return errorCallingFailureListener;
    }

    @Override
    public final void errorCallingLifeCycleListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorCallingLifeCycleListener$str(), new Object[0]);
    }

    protected String errorCallingLifeCycleListener$str() {
        return errorCallingLifeCycleListener;
    }

    @Override
    public final void errorCreatingNettyConnection(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorCreatingNettyConnection$str(), new Object[0]);
    }

    protected String errorCreatingNettyConnection$str() {
        return errorCreatingNettyConnection;
    }

    @Override
    public final void caughtunexpectedThrowable(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.caughtunexpectedThrowable$str(), new Object[0]);
    }

    protected String caughtunexpectedThrowable$str() {
        return caughtunexpectedThrowable;
    }

    @Override
    public final void errorOnXMLTransform(Throwable t, Node n) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorOnXMLTransform$str(), (Object)n);
    }

    protected String errorOnXMLTransform$str() {
        return errorOnXMLTransform;
    }

    @Override
    public final void errorOnXMLTransformInvalidConf(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorOnXMLTransformInvalidConf$str(), new Object[0]);
    }

    protected String errorOnXMLTransformInvalidConf$str() {
        return errorOnXMLTransformInvalidConf;
    }

    @Override
    public final void errorStoppingDiscoveryBroadcastEndpoint(Object endpoint, Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorStoppingDiscoveryBroadcastEndpoint$str(), endpoint);
    }

    protected String errorStoppingDiscoveryBroadcastEndpoint$str() {
        return errorStoppingDiscoveryBroadcastEndpoint;
    }

    @Override
    public final void invalidCipherSuite(String validSuites) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.invalidCipherSuite$str(), (Object)validSuites);
    }

    protected String invalidCipherSuite$str() {
        return invalidCipherSuite;
    }

    @Override
    public final void invalidProtocol(String validProtocols) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.invalidProtocol$str(), (Object)validProtocols);
    }

    protected String invalidProtocol$str() {
        return invalidProtocol;
    }

    @Override
    public final void httpHandshakeFailed(Object msg) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.httpHandshakeFailed$str(), msg);
    }

    protected String httpHandshakeFailed$str() {
        return httpHandshakeFailed;
    }

    @Override
    public final void httpUpgradeNotSupportedByRemoteAcceptor() {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.httpUpgradeNotSupportedByRemoteAcceptor$str(), new Object[0]);
    }

    protected String httpUpgradeNotSupportedByRemoteAcceptor$str() {
        return httpUpgradeNotSupportedByRemoteAcceptor;
    }

    @Override
    public final void invalidCFType(String type, String uri) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)null, this.invalidCFType$str(), (Object)type, (Object)uri);
    }

    protected String invalidCFType$str() {
        return invalidCFType;
    }

    @Override
    public final void failoverOrReconnect(Object connectionID, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.TRACE, cause, this.failoverOrReconnect$str(), connectionID);
    }

    protected String failoverOrReconnect$str() {
        return failoverOrReconnect;
    }

    @Override
    public final void replayingCommands(Object connectionID, int lastConfirmedCommandID) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.replayingCommands$str(), connectionID, (Object)lastConfirmedCommandID);
    }

    protected String replayingCommands$str() {
        return replayingCommands;
    }

    @Override
    public final void reconnectCreatingNewSession(long id) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.reconnectCreatingNewSession$str(), (Object)id);
    }

    protected String reconnectCreatingNewSession$str() {
        return reconnectCreatingNewSession;
    }

    @Override
    public final void unexpectedResponseFromHttpServer(Object response) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)null, this.unexpectedResponseFromHttpServer$str(), response);
    }

    protected String unexpectedResponseFromHttpServer$str() {
        return unexpectedResponseFromHttpServer;
    }
}

