/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.activemq.artemis.api.core;

import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.jgroups.JChannel;

import java.net.URL;

/**
 * This class is the implementation of ActiveMQ Artemis members discovery that will use JGroups.
 */
public final class JGroupsFileBroadcastEndpoint extends JGroupsBroadcastEndpoint {

   private String file;

   public JGroupsFileBroadcastEndpoint(final JChannelManager manager, final String file, final String channelName) throws Exception {
      super(manager, channelName);
      this.file = file;
   }

   public JChannel createChannel() throws Exception {
      URL configURL = Thread.currentThread().getContextClassLoader().getResource(file);

      if (configURL == null) {
         throw new RuntimeException("couldn't find JGroups configuration " + file);
      }

      return new JChannel(configURL);
   }
}
