/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.server.LiveNodeLocator;
import org.apache.activemq.artemis.core.server.cluster.qourum.SharedNothingBackupQuorum;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;

public class AnyLiveNodeLocatorForReplication
extends LiveNodeLocator {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ActiveMQServerImpl server;
    Map<String, Pair<TransportConfiguration, TransportConfiguration>> untriedConnectors = new HashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();
    Map<String, Pair<TransportConfiguration, TransportConfiguration>> triedConnectors = new HashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();
    private String nodeID;

    public AnyLiveNodeLocatorForReplication(SharedNothingBackupQuorum backupQuorum, ActiveMQServerImpl server) {
        super(backupQuorum);
        this.server = server;
    }

    @Override
    public void locateNode() throws ActiveMQException {
        this.locateNode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode(long timeout) throws ActiveMQException {
        block6: {
            try {
                this.lock.lock();
                if (!this.untriedConnectors.isEmpty()) break block6;
                try {
                    if (timeout != -1L) {
                        this.condition.await(timeout, TimeUnit.MILLISECONDS);
                        break block6;
                    }
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            Pair<TransportConfiguration, TransportConfiguration> connector = new Pair<TransportConfiguration, TransportConfiguration>(topologyMember.getLive(), topologyMember.getBackup());
            if (this.server.checkLiveIsNotColocated(topologyMember.getNodeId())) {
                this.untriedConnectors.put(topologyMember.getNodeId(), connector);
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDown(long eventUID, String nodeID) {
        try {
            this.lock.lock();
            this.untriedConnectors.putAll(this.triedConnectors);
            this.triedConnectors.clear();
            if (this.untriedConnectors.size() > 0) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration() {
        try {
            this.lock.lock();
            Iterator<String> iterator = this.untriedConnectors.keySet().iterator();
            if (iterator.hasNext()) {
                this.nodeID = iterator.next();
            }
            Pair<TransportConfiguration, TransportConfiguration> pair = this.untriedConnectors.get(this.nodeID);
            return pair;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            Pair<TransportConfiguration, TransportConfiguration> tc = this.untriedConnectors.remove(this.nodeID);
            if (tc != null) {
                this.triedConnectors.put(this.nodeID, tc);
            }
        }
        finally {
            this.lock.unlock();
        }
        super.notifyRegistrationFailed(alreadyReplicating);
    }
}

