package org.jgroups.tests;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

/**
 * Scattering reads reading 3 buffers: heap -> direct -> heap
 * @author Bela Ban
 * @since x.y
 */
public class bla8 {


    public static void main(String[] args) throws Exception {
        InetSocketAddress dest=new InetSocketAddress("localhost", 7500);
        Selector sel=Selector.open();
        SocketChannel ch=SocketChannel.open();
        ch.configureBlocking(false);
        SelectionKey key=ch.register(sel, SelectionKey.OP_CONNECT | SelectionKey.OP_WRITE);

        boolean rc=ch.connect(dest);
        if(rc)
            key.interestOps(key.interestOps() & ~SelectionKey.OP_CONNECT);
        System.out.println("rc = " + rc);

        for(;;) {
            int num=sel.select();
            System.out.println("num = " + num);
            Set<SelectionKey> keys=sel.selectedKeys();
            for(Iterator<SelectionKey> it=keys.iterator(); it.hasNext();) {
                SelectionKey k=it.next();
                it.remove();
                if(!k.isValid())
                    continue;
                if(k.isConnectable()) {
                    System.out.println("connectable");
                    rc=ch.finishConnect();
                    // commenting this below produces a bug: endless select() -> 0
                    if(rc)
                        k.interestOps(k.interestOps() & ~SelectionKey.OP_CONNECT);

                    k.interestOps(k.interestOps() | SelectionKey.OP_READ);
                }
                if(k.isReadable()) {
                    ByteBuffer buffer=ByteBuffer.allocate(128);
                    int read=ch.read(buffer);
                    System.out.println("read bytes = " + read);
                    String str=new String(((ByteBuffer)buffer.flip()).array(), 0, buffer.limit());
                    System.out.println("str = " + str);
                }
                if(k.isWritable()) {
                    k.interestOps(k.interestOps() & ~SelectionKey.OP_WRITE);
                }
            }
        }
    }

}
