/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Unmarshaller;

class SessionOpenResponseHandler
extends ProtocolMessageHandler {
    private final ChannelAssociation channelAssociation;
    private final MarshallerFactory marshallerFactory;

    SessionOpenResponseHandler(ChannelAssociation channelAssociation, MarshallerFactory marshallerFactory) {
        this.channelAssociation = channelAssociation;
        this.marshallerFactory = marshallerFactory;
    }

    @Override
    protected void processMessage(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw Logs.MAIN.paramCannotBeNull("Message input stream");
        }
        DataInputStream input = new DataInputStream(inputStream);
        short invocationId = input.readShort();
        SessionIDResultProducer resultProducer = new SessionIDResultProducer(input);
        this.channelAssociation.resultReady(invocationId, resultProducer);
    }

    final class SessionOpenResponse {
        private final SessionID sessionID;
        private final Affinity affinity;

        SessionOpenResponse(SessionID sessionID, Affinity affinity) {
            this.sessionID = sessionID;
            this.affinity = affinity;
        }

        SessionID getSessionID() {
            return this.sessionID;
        }

        Affinity getAffinity() {
            return this.affinity;
        }
    }

    private class SessionIDResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final DataInputStream input;

        SessionIDResultProducer(DataInputStream input) {
            this.input = input;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getResult() throws Exception {
            try {
                int sessionIdLength = PackedInteger.readPackedInteger(this.input);
                byte[] sessionIdBytes = new byte[sessionIdLength];
                this.input.read(sessionIdBytes);
                SessionID sessionID = SessionID.createSessionID(sessionIdBytes);
                Unmarshaller unmarshaller = SessionOpenResponseHandler.this.prepareForUnMarshalling(SessionOpenResponseHandler.this.marshallerFactory, this.input);
                Affinity affinity = (Affinity)unmarshaller.readObject();
                unmarshaller.finish();
                SessionOpenResponse sessionOpenResponse = new SessionOpenResponse(sessionID, affinity);
                return sessionOpenResponse;
            }
            finally {
                this.input.close();
            }
        }

        @Override
        public void discardResult() {
        }
    }
}

