/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import hu.vissy.texttable.BorderFormatter;
import hu.vissy.texttable.TableFormatter;
import hu.vissy.texttable.column.ColumnDefinition;
import hu.vissy.texttable.contentformatter.CellContentFormatter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.VersionResult;
import org.wildfly.channelplugin.AbstractChannelMojo;
import org.wildfly.channeltools.util.ConversionUtils;

@Mojo(name="verify-dependencies", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, aggregator=true, requiresDependencyResolution=ResolutionScope.COMPILE, inheritByDefault=false)
public class VerifyDependenciesMojo
extends AbstractChannelMojo {
    private static final String PLUGIN_DIRECTORY = "wildfly-channel-reports";
    private static final String UNALIGNED_REPORT_FILE = "unaligned-dependencies.txt";
    private static final String STREAM_NOT_FOUND_REPORT_FILE = "dependencies-missing-from-channels.txt";
    @Parameter(property="failBuild", defaultValue="true")
    boolean failBuild;
    @Parameter(property="failWhenStreamNotFound", defaultValue="false")
    boolean failWhenStreamNotFound;
    @Parameter(property="ignoreStreams")
    List<String> ignoreStreams;
    @Parameter(property="ignoreScopes", defaultValue="test")
    List<String> ignoreScopes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initChannelSession();
        List ignoredStreams = this.ignoreStreams.stream().map(SimpleProjectRef::parse).collect(Collectors.toList());
        ArrayList<Pair<ArtifactRef, String>> unalignedDependencies = new ArrayList<Pair<ArtifactRef, String>>();
        ArrayList<ArtifactRef> streamNotFoundDependencies = new ArrayList<ArtifactRef>();
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        projects.add(this.mavenProject);
        projects.addAll(this.mavenProject.getCollectedProjects());
        for (MavenProject project : projects) {
            Model model = project.getModel();
            List dependencies = model.getDependencies().stream().filter(d -> !this.ignoreScopes.contains(d.getScope())).map(ConversionUtils::toArtifactRef).collect(Collectors.toList());
            for (ArtifactRef d2 : dependencies) {
                try {
                    VersionResult result = this.channelSession.findLatestMavenArtifactVersion(d2.getGroupId(), d2.getArtifactId(), d2.getType(), d2.getClassifier(), d2.getVersionString());
                    String expectedVersion = result.getVersion();
                    if (d2.getVersionString().equals(expectedVersion)) continue;
                    if (ignoredStreams.contains(new SimpleProjectRef(d2.getGroupId(), d2.getArtifactId()))) {
                        this.getLog().info((CharSequence)String.format("Ignoring dependency %s:%s:%s not matching %s", d2.getGroupId(), d2.getArtifactId(), d2.getVersionString(), expectedVersion));
                        continue;
                    }
                    unalignedDependencies.add((Pair<ArtifactRef, String>)Pair.of((Object)d2, (Object)expectedVersion));
                }
                catch (NoStreamFoundException e) {
                    String message = String.format("Artifact %s:%s:%s not present in configured channels.", d2.getGroupId(), d2.getArtifactId(), d2.getVersionString());
                    streamNotFoundDependencies.add(d2);
                    if (this.failWhenStreamNotFound) {
                        throw new MojoFailureException(message, (Throwable)e);
                    }
                    this.getLog().warn((CharSequence)message);
                }
            }
        }
        this.printReportFiles(unalignedDependencies, streamNotFoundDependencies);
        if (!unalignedDependencies.isEmpty()) {
            unalignedDependencies.forEach(pair -> {
                ArtifactRef dep = (ArtifactRef)pair.getLeft();
                String v = (String)pair.getRight();
                this.getLog().error((CharSequence)String.format("Dependency %s:%s:%s doesn't match expected version %s", dep.getGroupId(), dep.getArtifactId(), dep.getVersionString(), v));
            });
            if (this.failBuild) {
                throw new MojoFailureException("Project dependencies are not aligned according to specified channels.");
            }
        }
    }

    private void printReportFiles(List<Pair<ArtifactRef, String>> unalignedDependencies, List<ArtifactRef> streamNotFoundDependencies) throws MojoExecutionException {
        Path buildDirectory = Path.of(this.mavenProject.getBuild().getDirectory(), new String[0]);
        Path pluginDirectory = buildDirectory.resolve(PLUGIN_DIRECTORY);
        Path unalignedReportFile = pluginDirectory.resolve(UNALIGNED_REPORT_FILE);
        Path streamNotFoundReportFile = pluginDirectory.resolve(STREAM_NOT_FOUND_REPORT_FILE);
        try {
            if (!Files.exists(buildDirectory, new LinkOption[0])) {
                Files.createDirectory(buildDirectory, new FileAttribute[0]);
            }
            if (!Files.exists(pluginDirectory, new LinkOption[0])) {
                Files.createDirectory(pluginDirectory, new FileAttribute[0]);
            }
            if (!unalignedDependencies.isEmpty()) {
                Files.writeString(unalignedReportFile, (CharSequence)VerifyDependenciesMojo.unalignedDependenciesTable(unalignedDependencies), new OpenOption[0]);
            }
            if (!streamNotFoundDependencies.isEmpty()) {
                Files.writeString(streamNotFoundReportFile, (CharSequence)VerifyDependenciesMojo.streamNotFoundDependenciesTable(streamNotFoundDependencies), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write report file " + unalignedReportFile, (Exception)e);
        }
    }

    static String unalignedDependenciesTable(List<Pair<ArtifactRef, String>> data) {
        TableFormatter formatter = new TableFormatter.Builder().withHeading("Following dependencies are not aligned with specified channels").withSeparateDataWithLines(true).withBorderFormatter(new BorderFormatter.Builder(BorderFormatter.DefaultFormatters.NO_VERTICAL).build()).withColumn(((ColumnDefinition.StatelessBuilder)((ColumnDefinition.StatelessBuilder)new ColumnDefinition.StatelessBuilder().withTitle("Dependency")).withDataExtractor(d -> String.format("%s:%s:%s", ((ArtifactRef)d.getLeft()).getGroupId(), ((ArtifactRef)d.getLeft()).getArtifactId(), ((ArtifactRef)d.getLeft()).getVersionString())).withCellContentFormatter(new CellContentFormatter.Builder().withMinWidth(8).build())).build()).withColumn(((ColumnDefinition.StatelessBuilder)new ColumnDefinition.StatelessBuilder().withTitle("Expected Version")).withDataExtractor(Pair::getRight).build()).build();
        return formatter.apply(data);
    }

    static String streamNotFoundDependenciesTable(List<ArtifactRef> data) {
        TableFormatter formatter = new TableFormatter.Builder().withHeading("Following dependencies are not represented in specified channels").withSeparateDataWithLines(true).withBorderFormatter(new BorderFormatter.Builder(BorderFormatter.DefaultFormatters.NO_VERTICAL).build()).withColumn(((ColumnDefinition.StatelessBuilder)((ColumnDefinition.StatelessBuilder)new ColumnDefinition.StatelessBuilder().withTitle("Dependency")).withDataExtractor(d -> String.format("%s:%s:%s", d.getGroupId(), d.getArtifactId(), d.getVersionString())).withCellContentFormatter(new CellContentFormatter.Builder().withMinWidth(8).build())).build()).build();
        return formatter.apply(data);
    }
}

