/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.job.repository;

import org.jberet.repository.JobRepository;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.job.repository.InMemoryJobRepositoryService;

public class InMemoryJobRepositoryDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "in-memory-job-repository";
    static final PathElement PATH = PathElement.pathElement((String)"in-memory-job-repository");

    public InMemoryJobRepositoryDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, (ResourceDescriptionResolver)BatchResourceDescriptionResolver.getResourceDescriptionResolver(NAME)).setAddHandler((OperationStepHandler)new InMemoryAddHandler()).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler(new RuntimeCapability[]{Capabilities.JOB_REPOSITORY_CAPABILITY})).setCapabilities(new RuntimeCapability[]{Capabilities.JOB_REPOSITORY_CAPABILITY}));
    }

    private static class InMemoryAddHandler
    extends AbstractAddStepHandler {
        InMemoryAddHandler() {
            super(Capabilities.JOB_REPOSITORY_CAPABILITY, new AttributeDefinition[0]);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String name = context.getCurrentAddressValue();
            context.getServiceTarget().addService(context.getCapabilityServiceName(Capabilities.JOB_REPOSITORY_CAPABILITY.getName(), name, JobRepository.class), (Service)new InMemoryJobRepositoryService()).install();
        }
    }
}

