package org.wildfly.extension.batch.jberet._private;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import javax.batch.operations.JobStartException;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.batch.operations.NoSuchJobException;
import org.jboss.as.controller.PathElement;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.BatchRuntimeException;
import org.jboss.logging.BasicLogger;
import java.security.Permission;
import java.lang.Throwable;
import java.lang.ClassLoader;
import org.jboss.msc.service.StartException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-08-30T16:57:30-0500")
public class BatchLogger_$logger extends DelegatingBasicLogger implements BatchLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BatchLogger_$logger.class.getName();
    public BatchLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String errorProcessingBatchJobsDir = "WFLYBATCH000001: Error processing META-INF/batch-jobs directory.";
    protected String errorProcessingBatchJobsDir$str() {
        return errorProcessingBatchJobsDir;
    }
    @Override
    public final DeploymentUnitProcessingException errorProcessingBatchJobsDir(final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), errorProcessingBatchJobsDir$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveResourceOfType = "WFLYBATCH000002: Resources of type %s cannot be removed";
    protected String cannotRemoveResourceOfType$str() {
        return cannotRemoveResourceOfType;
    }
    @Override
    public final UnsupportedOperationException cannotRemoveResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), cannotRemoveResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindDeploymentName = "WFLYBATCH000003: Could not find deployment name: %s";
    protected String couldNotFindDeploymentName$str() {
        return couldNotFindDeploymentName;
    }
    @Override
    public final IllegalArgumentException couldNotFindDeploymentName(final String address) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotFindDeploymentName$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jobOperatorServiceStopped = "WFLYBATCH000004: The service JobOperatorService has been stopped and cannot execute operations.";
    protected String jobOperatorServiceStopped$str() {
        return jobOperatorServiceStopped;
    }
    @Override
    public final IllegalStateException jobOperatorServiceStopped() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), jobOperatorServiceStopped$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchJobException = "WFLYBATCH000005: The job name '%s' was not found for the deployment.";
    protected String noSuchJobException$str() {
        return noSuchJobException;
    }
    @Override
    public final NoSuchJobException noSuchJobException(final String jobName) {
        final NoSuchJobException result = new NoSuchJobException(String.format(getLoggingLocale(), noSuchJobException$str(), jobName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindJobXml = "WFLYBATCH000006: Could not find the job XML file in the deployment: %s";
    protected String couldNotFindJobXml$str() {
        return couldNotFindJobXml;
    }
    @Override
    public final JobStartException couldNotFindJobXml(final String xmlFile) {
        final JobStartException result = new JobStartException(String.format(getLoggingLocale(), couldNotFindJobXml$str(), xmlFile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invalidJobXmlFile(final String jobXmlFile) {
        super.log.logf(FQCN, WARN, null, invalidJobXmlFile$str(), jobXmlFile);
    }
    private static final String invalidJobXmlFile = "WFLYBATCH000007: Failed processing the job XML file %s. Attempting to execute this job may result in errors.";
    protected String invalidJobXmlFile$str() {
        return invalidJobXmlFile;
    }
    @Override
    public final void emptyJobRepositoryElement(final String deploymentName) {
        super.log.logf(FQCN, WARN, null, emptyJobRepositoryElement$str(), deploymentName);
    }
    private static final String emptyJobRepositoryElement = "WFLYBATCH000008: Empty job-repository element found in deployment descriptor. Using the default job repository for deployment %s.";
    protected String emptyJobRepositoryElement$str() {
        return emptyJobRepositoryElement;
    }
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYBATCH000009: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }
    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(final PathElement address) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), indexedChildResourceRegistrationNotAvailable$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreateJobRepository = "WFLYBATCH000011: Failed to create %s job repository.";
    protected String failedToCreateJobRepository$str() {
        return failedToCreateJobRepository;
    }
    @Override
    public final StartException failedToCreateJobRepository(final Throwable cause, final String type) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToCreateJobRepository$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void multipleJobRepositoriesFound() {
        super.log.logf(FQCN, ERROR, null, multipleJobRepositoriesFound$str());
    }
    private static final String multipleJobRepositoriesFound = "WFLYBATCH000013: Only one job repository can be defined in the jboss-all.xml deployment descriptor. The first job repository will be used.";
    protected String multipleJobRepositoriesFound$str() {
        return multipleJobRepositoriesFound;
    }
    @Override
    public final void stoppingJob(final long executionId, final String jobName, final String deploymentName) {
        super.log.logf(FQCN, WARN, null, stoppingJob$str(), executionId, jobName, deploymentName);
    }
    private static final String stoppingJob = "WFLYBATCH000014: Stopping execution %d of %s for deployment %s";
    protected String stoppingJob$str() {
        return stoppingJob;
    }
    @Override
    public final void stoppingJobFailed(final Throwable cause, final long executionId, final String jobName, final String deploymentName) {
        super.log.logf(FQCN, ERROR, cause, stoppingJobFailed$str(), executionId, jobName, deploymentName);
    }
    private static final String stoppingJobFailed = "WFLYBATCH000015: Failed to stop execution %d for job %s on deployment %s";
    protected String stoppingJobFailed$str() {
        return stoppingJobFailed;
    }
    @Override
    public final void failedRestartingJob(final Throwable cause, final long executionId, final String jobName, final String deploymentName) {
        super.log.logf(FQCN, ERROR, cause, failedRestartingJob$str(), executionId, jobName, deploymentName);
    }
    private static final String failedRestartingJob = "WFLYBATCH000016: Failed to restart execution %d for job %s on deployment %s";
    protected String failedRestartingJob$str() {
        return failedRestartingJob;
    }
    @Override
    public final void restartingJob(final String jobName, final long previousId, final long newId) {
        super.log.logf(FQCN, INFO, null, restartingJob$str(), jobName, previousId, newId);
    }
    private static final String restartingJob = "WFLYBATCH000017: Restarting previously stopped batch job %s. Previous execution id %d. New execution id %d.";
    protected String restartingJob$str() {
        return restartingJob;
    }
    private static final String noBatchEnvironmentFound = "WFLYBATCH000019: No batch environment was found for class loader: %s";
    protected String noBatchEnvironmentFound$str() {
        return noBatchEnvironmentFound;
    }
    @Override
    public final BatchRuntimeException noBatchEnvironmentFound(final ClassLoader cl) {
        final BatchRuntimeException result = new BatchRuntimeException(String.format(getLoggingLocale(), noBatchEnvironmentFound$str(), cl));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorized = "WFLYBATCH000020: Permission denied. User %s does not have %s permissions.";
    protected String unauthorized$str() {
        return unauthorized;
    }
    @Override
    public final JobSecurityException unauthorized(final String user, final Permission permission) {
        final JobSecurityException result = new JobSecurityException(String.format(getLoggingLocale(), unauthorized$str(), user, permission));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
