/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.protocol.jmx;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;

public class ServerKillerExtension {
    public static final String ORG_WILDFLY_TEST_KILL_SERVERS_BEFORE_TEST = "org.wildfly.test.kill-servers-before-test";
    private static volatile String errorProcessTable;
    private static boolean runOncePerSuite;
    private String javaHome = System.getenv("JAVA_HOME");

    public ServerKillerExtension() {
        if (this.javaHome == null) {
            this.javaHome = System.getProperty("java.home");
        }
    }

    public void beforeSuite(@Observes BeforeSetup start) {
        if (runOncePerSuite) {
            this.killServers();
        }
    }

    public void killServers() {
        if (!Boolean.getBoolean(ORG_WILDFLY_TEST_KILL_SERVERS_BEFORE_TEST)) {
            return;
        }
        runOncePerSuite = false;
        Runtime rt = Runtime.getRuntime();
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            this.killWindows(rt);
        } else {
            this.killLinux(rt);
        }
    }

    public void throwErrpr(@Observes AfterSuite start) {
        runOncePerSuite = true;
        String result = errorProcessTable;
        errorProcessTable = null;
        if (result != null) {
            throw new RuntimeException("There was a server running at the start of the test run execution. jstack output was \n" + result);
        }
    }

    private String getJStackPath() {
        return this.javaHome + File.separator + "bin" + File.separator + "jstack";
    }

    private String getJps() {
        return this.javaHome + File.separator + "bin" + File.separator + "jps";
    }

    private void killLinux(Runtime rt) {
        try {
            String running;
            Process process = rt.exec(new String[]{"/bin/sh", "-c", this.getJps() + " | egrep -v \"Jps|AgentMain|Launcher|RemoteMavenServer\" | awk '{ print $1; }' | xargs --no-run-if-empty " + this.getJStackPath()});
            InputStream in = process.getInputStream();
            String processTable = ServerKillerExtension.readString(in);
            ServerKillerExtension.readString(process.getErrorStream());
            if (!processTable.isEmpty()) {
                ServerKillerExtension.readString(rt.exec(new String[]{"/bin/sh", "-c", this.getJps() + " | egrep -v \"Jps|AgentMain|Launcher|RemoteMavenServer\" | awk '{ print $1; }' | xargs --no-run-if-empty kill -9"}).getInputStream());
                errorProcessTable = processTable;
            }
            long end = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < end && !(running = ServerKillerExtension.readString(rt.exec(new String[]{"/bin/sh", "-c", this.getJps() + " | egrep -v \"Jps|AgentMain|Launcher|RemoteMavenServer\" | awk '{ print $1; }' | xargs --no-run-if-empty " + this.getJStackPath()}).getInputStream())).isEmpty()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void killWindows(Runtime rt) {
        String GET_PROCESSES_COMMAND = "gwmi win32_process -filter \"name='java.exe' and commandLine like '%jboss-modules%' \" | foreach { " + this.getJStackPath() + " $_.ProcessId }";
        String KILL_PROCESSES_COMMAND = "gwmi win32_process -filter \"name='java.exe' and commandLine like '%jboss-modules%' \" | foreach { kill -id $_.ProcessId }";
        try {
            String running;
            Path getProcessCommand = ServerKillerExtension.createCommandFile(GET_PROCESSES_COMMAND);
            Process process = rt.exec(new String[]{"powershell.exe", "-NoProfile", "-NonInteractive", "-ExecutionPolicy", "ByPass", getProcessCommand.toString()});
            InputStream in = process.getInputStream();
            String processTable = ServerKillerExtension.readString(in);
            String errors = ServerKillerExtension.readString(process.getErrorStream());
            if (errors != null && !errors.isEmpty()) {
                System.out.println("Could not get processes:\n" + errors);
            }
            if (!processTable.isEmpty()) {
                Path killProcessesCommand = ServerKillerExtension.createCommandFile("gwmi win32_process -filter \"name='java.exe' and commandLine like '%jboss-modules%' \" | foreach { kill -id $_.ProcessId }");
                ServerKillerExtension.readString(rt.exec(new String[]{"powershell.exe", "-NoProfile", "-NonInteractive", "-ExecutionPolicy", "ByPass", killProcessesCommand.toString()}).getInputStream());
                errorProcessTable = processTable;
                Files.delete(killProcessesCommand);
            }
            long end = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < end && !(running = ServerKillerExtension.readString(rt.exec(new String[]{"powershell.exe", "-NoProfile", "-NonInteractive", "-ExecutionPolicy", "ByPass", getProcessCommand.toString()}).getInputStream())).isEmpty()) {
                Thread.sleep(100L);
            }
            Files.delete(getProcessCommand);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Path createCommandFile(String command) throws IOException {
        Path tmp = Files.createTempFile("pskiller", ".ps1", new FileAttribute[0]);
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmp.toFile()));){
            bos.write(command.getBytes());
        }
        tmp.toFile().deleteOnExit();
        return tmp;
    }

    public static String readString(InputStream file) {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file);
            byte[] buff = new byte[1024];
            StringBuilder builder = new StringBuilder();
            int read = -1;
            while ((read = stream.read(buff)) != -1) {
                builder.append(new String(buff, 0, read));
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static {
        runOncePerSuite = true;
    }
}

