/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.protocol.jmx;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.protocol.jmx.AbstractJMXProtocol;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.arquillian.container.NetworkUtils;
import org.jboss.as.arquillian.container.OSGiApplicationArchiveProcessor;
import org.jboss.as.arquillian.protocol.jmx.JMXProtocolAS7;
import org.jboss.as.arquillian.protocol.jmx.ManifestUtils;
import org.jboss.as.arquillian.service.ArquillianService;
import org.jboss.as.arquillian.service.DependenciesProvider;
import org.jboss.as.arquillian.service.InContainerManagementClientExtension;
import org.jboss.as.arquillian.service.JMXProtocolEndpointExtension;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.osgi.metadata.ManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class JMXProtocolPackager
implements DeploymentPackager {
    private static final List<String> defaultDependencies = new ArrayList<String>();
    private static final Logger log;
    private JMXProtocolAS7.ServiceArchiveHolder archiveHolder;

    JMXProtocolPackager(JMXProtocolAS7.ServiceArchiveHolder archiveHolder) {
        this.archiveHolder = archiveHolder;
    }

    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> protocolProcessors) {
        Archive appArchive = testDeployment.getApplicationArchive();
        if (this.archiveHolder.getArchive() == null) {
            try {
                Collection auxArchives = testDeployment.getAuxiliaryArchives();
                JavaArchive archive = this.generateArquillianServiceArchive(auxArchives);
                this.archiveHolder.setArchive((Archive<?>)archive);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot generate arquillian service", ex);
            }
        }
        this.addModulesManifestDependencies(appArchive);
        this.archiveHolder.addPreparedDeployment(testDeployment.getDeploymentName());
        return appArchive;
    }

    private JavaArchive generateArquillianServiceArchive(Collection<Archive<?>> auxArchives) throws Exception {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-service");
        log.debugf("Generating: %s", (Object)archive.getName());
        archive.addPackage(ArquillianService.class.getPackage());
        archive.addPackage(AbstractJMXProtocol.class.getPackage());
        archive.addClasses(new Class[]{ServerSetup.class, ServerSetupTask.class, ManagementClient.class, Authentication.class, NetworkUtils.class});
        final LinkedHashSet<ModuleIdentifier> archiveDependencies = new LinkedHashSet<ModuleIdentifier>();
        archiveDependencies.add(ModuleIdentifier.create((String)"org.jboss.as.jmx"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.jboss.as.server"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.jboss.as.controller-client"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.jboss.jandex"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.jboss.logging"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.jboss.modules"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.jboss.dmr"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.jboss.msc"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.osgi.core"));
        archiveDependencies.add(ModuleIdentifier.create((String)"org.wildfly.security.manager"));
        final HashSet<String> loadableExtensions = new HashSet<String>();
        String loadableExtensionsPath = "META-INF/services/" + RemoteLoadableExtension.class.getName();
        for (Archive<?> aux : auxArchives) {
            Node node = aux.get(loadableExtensionsPath);
            if (node != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(node.getAsset().openStream()));
                String line = br.readLine();
                while (line != null) {
                    loadableExtensions.add(line);
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Object extension = classLoader.loadClass(line).newInstance();
                    if (extension instanceof DependenciesProvider) {
                        DependenciesProvider provider = (DependenciesProvider)extension;
                        archiveDependencies.addAll(provider.getDependencies());
                    }
                    line = br.readLine();
                }
            }
            log.debugf("Merging archive: %s", aux);
            archive.merge(aux);
        }
        loadableExtensions.add(JMXProtocolEndpointExtension.class.getName());
        loadableExtensions.add(InContainerManagementClientExtension.class.getName());
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = ManifestBuilder.newInstance();
                Iterator itdep = archiveDependencies.iterator();
                StringBuffer depspec = new StringBuffer("" + itdep.next());
                while (itdep.hasNext()) {
                    depspec.append("," + itdep.next());
                }
                builder.addManifestHeader("Dependencies", depspec.toString());
                return builder.openStream();
            }
        });
        String serviceActivatorPath = "META-INF/services/" + ServiceActivator.class.getName();
        URL serviceActivatorURL = this.getClass().getClassLoader().getResource("arquillian-service/" + serviceActivatorPath);
        if (serviceActivatorURL == null) {
            throw new RuntimeException("No arquillian-service/" + serviceActivatorPath + " found by classloader: " + this.getClass().getClassLoader());
        }
        archive.addAsResource((Asset)new UrlAsset(serviceActivatorURL), serviceActivatorPath);
        archive.addAsResource(new Asset(){

            public InputStream openStream() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    Properties props = new Properties();
                    props.setProperty("Bundle-SymbolicName", "arquillian-service");
                    StringBuilder builder = new StringBuilder();
                    builder.append("org.jboss.arquillian.container.test.api,org.jboss.arquillian.junit,");
                    builder.append("org.jboss.arquillian.osgi,org.jboss.arquillian.test.api,");
                    builder.append("org.jboss.as.arquillian.api,org.jboss.as.arquillian.container,");
                    builder.append("org.jboss.shrinkwrap.api,org.jboss.shrinkwrap.api.asset,org.jboss.shrinkwrap.api.spec,");
                    builder.append("org.junit,org.junit.runner");
                    props.setProperty("Export-Package", builder.toString());
                    props.store(baos, null);
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot write osgi metadata", ex);
                }
                return new ByteArrayInputStream(baos.toByteArray());
            }
        }, "META-INF/jbosgi-xservice.properties");
        archive.delete(ArchivePaths.create((String)loadableExtensionsPath));
        archive.addAsResource(new Asset(){

            public InputStream openStream() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
                for (String line : loadableExtensions) {
                    pw.println(line);
                }
                pw.close();
                return new ByteArrayInputStream(baos.toByteArray());
            }
        }, loadableExtensionsPath);
        log.debugf("Loadable extensions: %s", loadableExtensions);
        log.tracef("Archive content: %s\n%s", (Object)archive, (Object)archive.toString(true));
        return archive;
    }

    private void addModulesManifestDependencies(Archive<?> appArchive) {
        String value;
        if (!(appArchive instanceof ManifestContainer)) {
            throw new IllegalArgumentException("ManifestContainer expected " + appArchive);
        }
        final Manifest manifest = ManifestUtils.getOrCreateManifest(appArchive);
        if (OSGiApplicationArchiveProcessor.isValidOSGiBundleArchive(appArchive)) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION.toString()) == null) {
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        }
        StringBuffer moduleDeps = new StringBuffer((value = attributes.getValue("Dependencies")) != null && value.trim().length() > 0 ? value : "org.jboss.modules");
        for (String dep : defaultDependencies) {
            if (moduleDeps.indexOf(dep) >= 0) continue;
            moduleDeps.append("," + dep);
        }
        log.debugf("Add dependencies: %s", (Object)moduleDeps);
        attributes.putValue("Dependencies", moduleDeps.toString());
        ArchivePath manifestPath = ArchivePaths.create((String)"META-INF/MANIFEST.MF");
        appArchive.delete(manifestPath);
        appArchive.add(new Asset(){

            public InputStream openStream() {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    return new ByteArrayInputStream(baos.toByteArray());
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot write manifest", ex);
                }
            }
        }, manifestPath);
    }

    static {
        defaultDependencies.add("deployment.arquillian-service");
        defaultDependencies.add("org.jboss.modules");
        defaultDependencies.add("org.jboss.msc");
        defaultDependencies.add("org.osgi.core");
        defaultDependencies.add("org.wildfly.security.manager");
        log = Logger.getLogger(JMXProtocolPackager.class);
    }
}

