/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mail.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.mail.MailFraction;
import org.wildfly.swarm.mail.SmtpServer;

public class MailConfiguration
extends AbstractServerConfiguration<MailFraction> {
    private PathAddress smtpServerAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"mail")});

    public MailConfiguration() {
        super(MailFraction.class);
    }

    public MailFraction defaultFraction() {
        return new MailFraction();
    }

    public List<ModelNode> getList(MailFraction fraction) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode node = new ModelNode();
        node.get("address").set("extension", "org.jboss.as.mail");
        node.get("operation").set("add");
        list.add(node);
        node = new ModelNode();
        node.get("address").set(this.smtpServerAddress.toModelNode());
        node.get("operation").set("add");
        list.add(node);
        this.addSmtpServers(fraction, list);
        return list;
    }

    protected void addSmtpServers(MailFraction fraction, List<ModelNode> list) {
        for (SmtpServer each : fraction.smtpServers()) {
            this.addSmtpServer(each, list);
        }
    }

    protected void addSmtpServer(SmtpServer smtpServer, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.smtpServerAddress.append("mail-session", smtpServer.name().toLowerCase()).toModelNode());
        node.get("operation").set("add");
        node.get("jndi-name").set(smtpServer.jndiName());
        list.add(node);
        node = new ModelNode();
        node.get("address").set(this.smtpServerAddress.append("mail-session", smtpServer.name().toLowerCase()).append("server", "smtp").toModelNode());
        node.get("operation").set("add");
        node.get("outbound-socket-binding-ref").set(smtpServer.outboundSocketBindingRef());
        list.add(node);
        node = new ModelNode();
        node.get("address").set(PathAddress.pathAddress((String)"socket-binding-group", (String)"default-sockets").append("remote-destination-outbound-socket-binding", smtpServer.outboundSocketBindingRef()).toModelNode());
        node.get("operation").set("add");
        node.get("host").set(smtpServer.host());
        node.get("port").set(smtpServer.port());
        list.add(node);
    }
}

