/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.MavenArtifactUtil;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.wildfly.swarm.bootstrap.util.Layout;

public class BootstrapModuleFinder
implements ModuleFinder {
    @Override
    public ModuleSpec findModule(ModuleIdentifier identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        if (!identifier.getName().equals("org.wildfly.swarm.bootstrap")) {
            return null;
        }
        ModuleSpec.Builder builder = ModuleSpec.build(identifier);
        try {
            if (Layout.isFatJar()) {
                this.gatherJarsFromJar(builder);
            }
        }
        catch (IOException e) {
            throw new ModuleLoadException(e);
        }
        builder.addDependency(DependencySpec.createLocalDependencySpec());
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.modules")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.msc")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.shrinkwrap")));
        builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("javax.api")));
        return builder.create();
    }

    protected void gatherJarsFromJar(ModuleSpec.Builder builder) throws IOException {
        InputStream bootstrapTxt = this.getClass().getClassLoader().getResourceAsStream("META-INF/wildfly-swarm-bootstrap.conf");
        if (bootstrapTxt != null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(bootstrapTxt));){
                String line = null;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    File artifact = MavenArtifactUtil.resolveJarArtifact(line);
                    if (artifact == null) {
                        throw new IOException("Unable to locate artifact: " + line);
                    }
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createJarResourceLoader(artifact.getName(), new JarFile(artifact))));
                }
            }
        }
    }
}

