/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=undertow/server=*/ajp-listener=*")
@ResourceType(value="ajp-listener")
public class AJPListener<T extends AJPListener<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="If a request comes in with encoded / characters (i.e. %2F), will these be decoded.")
    private Boolean allowEncodedSlash;
    @AttributeDocumentation(value="If this is true then Undertow will allow non-escaped equals characters in unquoted cookie values. Unquoted cookie values may not contain equals characters. If present the value ends before the equals sign. The remainder of the cookie value will be dropped.")
    private Boolean allowEqualsInCookieValue;
    @AttributeDocumentation(value="If this is true then a Connection: keep-alive header will be added to responses, even when it is not strictly required by the specification.")
    private Boolean alwaysSetKeepAlive;
    @AttributeDocumentation(value="If we should buffer pipelined requests.")
    private Boolean bufferPipelinedData;
    @AttributeDocumentation(value="The listeners buffer pool")
    private String bufferPool;
    @AttributeDocumentation(value="The number of bytes that have been received by this listener")
    private Long bytesReceived;
    @AttributeDocumentation(value="The number of bytes that have been sent out on this listener")
    private Long bytesSent;
    @AttributeDocumentation(value="If this is true then the parser will decode the URL and query parameters using the selected character encoding (UTF-8 by default). If this is false they will not be decoded. This will allow a later handler to decode them into whatever charset is desired.")
    private Boolean decodeUrl;
    @AttributeDocumentation(value="A comma separated list of HTTP methods that are not allowed")
    private List<String> disallowedMethods;
    @AttributeDocumentation(value="The number of 500 responses that have been sent by this listener")
    private Long errorCount;
    @AttributeDocumentation(value="The maximum supported size of AJP packets. If this is modified it has to be increased on the load balancer and the backend server.")
    private Integer maxAjpPacketSize;
    @AttributeDocumentation(value="Maximum size of a buffered request, in bytes. Requests are not usually buffered, the most common case is when performing SSL renegotiation for a POST request, and the post data must be fully buffered in order to perform the renegotiation.")
    private Integer maxBufferedRequestSize;
    @AttributeDocumentation(value="The maximum number of concurrent connections. Only values greater than 0 are allowed. For unlimited connections simply undefine this attribute value.")
    private Integer maxConnections;
    @AttributeDocumentation(value="The maximum number of cookies that will be parsed. This is used to protect against hash vulnerabilities.")
    private Integer maxCookies;
    @AttributeDocumentation(value="The maximum size of a http request header, in bytes.")
    private Integer maxHeaderSize;
    @AttributeDocumentation(value="The maximum number of headers that will be parsed. This is used to protect against hash vulnerabilities.")
    private Integer maxHeaders;
    @AttributeDocumentation(value="The maximum number of parameters that will be parsed. This is used to protect against hash vulnerabilities. This applies to both query parameters, and to POST data, but is not cumulative (i.e. you can potentially have max parameters * 2 total parameters).")
    private Integer maxParameters;
    @AttributeDocumentation(value="The maximum size of a post that will be accepted, in bytes.")
    private Long maxPostSize;
    @AttributeDocumentation(value="The maximum processing time taken by a request on this listener")
    private Long maxProcessingTime;
    @AttributeDocumentation(value="The length of time in milliseconds that the connection can be idle before it is closed by the container.")
    private Integer noRequestTimeout;
    @AttributeDocumentation(value="The total processing time of all requests handed by this listener")
    private Long processingTime;
    @AttributeDocumentation(value="Configure a read timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful read taking place, the socket's next read will throw a {@link ReadTimeoutException}.")
    private Integer readTimeout;
    @AttributeDocumentation(value="The receive buffer size, in bytes.")
    private Integer receiveBuffer;
    @AttributeDocumentation(value="If this is true then Undertow will record the request start time, to allow for request time to be logged. This has a small but measurable performance impact")
    private Boolean recordRequestStartTime;
    @AttributeDocumentation(value="If this listener is supporting non-SSL requests, and a request is received for which a matching <security-constraint> requires SSL transport, undertow will automatically redirect the request to the socket binding port specified here.")
    private String redirectSocket;
    @AttributeDocumentation(value="The number of requests this listener has served")
    private Long requestCount;
    @AttributeDocumentation(value="The maximum amount of time (in milliseconds) that can be spent parsing the request")
    private Integer requestParseTimeout;
    @AttributeDocumentation(value="Enables host dns lookup")
    private Boolean resolvePeerAddress;
    @AttributeDocumentation(value="If cookies should be validated to ensure they comply with RFC6265.")
    private Boolean rfc6265CookieValidation;
    @AttributeDocumentation(value="The listener scheme, can be HTTP or HTTPS. By default the scheme will be taken from the incoming AJP request.")
    private String scheme;
    @AttributeDocumentation(value="If this is true then requests that originate from this listener are marked as secure, even if the request is not using HTTPS.")
    private Boolean secure;
    @AttributeDocumentation(value="The send buffer size, in bytes.")
    private Integer sendBuffer;
    @AttributeDocumentation(value="The listener socket binding")
    private String socketBinding;
    @AttributeDocumentation(value="Configure a server with the specified backlog.")
    private Integer tcpBacklog;
    @AttributeDocumentation(value="Configure a channel to send TCP keep-alive messages in an implementation-dependent manner.")
    private Boolean tcpKeepAlive;
    @AttributeDocumentation(value="URL charset")
    private String urlCharset;
    @AttributeDocumentation(value="The listeners XNIO worker")
    private String worker;
    @AttributeDocumentation(value="Configure a write timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful write taking place, the socket's next write will throw a {@link WriteTimeoutException}.")
    private Integer writeTimeout;

    public AJPListener(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="allow-encoded-slash")
    public Boolean allowEncodedSlash() {
        return this.allowEncodedSlash;
    }

    public T allowEncodedSlash(Boolean value) {
        Boolean oldValue = this.allowEncodedSlash;
        this.allowEncodedSlash = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowEncodedSlash", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-equals-in-cookie-value")
    public Boolean allowEqualsInCookieValue() {
        return this.allowEqualsInCookieValue;
    }

    public T allowEqualsInCookieValue(Boolean value) {
        Boolean oldValue = this.allowEqualsInCookieValue;
        this.allowEqualsInCookieValue = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowEqualsInCookieValue", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="always-set-keep-alive")
    public Boolean alwaysSetKeepAlive() {
        return this.alwaysSetKeepAlive;
    }

    public T alwaysSetKeepAlive(Boolean value) {
        Boolean oldValue = this.alwaysSetKeepAlive;
        this.alwaysSetKeepAlive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("alwaysSetKeepAlive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-pipelined-data")
    public Boolean bufferPipelinedData() {
        return this.bufferPipelinedData;
    }

    public T bufferPipelinedData(Boolean value) {
        Boolean oldValue = this.bufferPipelinedData;
        this.bufferPipelinedData = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferPipelinedData", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-pool")
    public String bufferPool() {
        return this.bufferPool;
    }

    public T bufferPool(String value) {
        String oldValue = this.bufferPool;
        this.bufferPool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferPool", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="bytes-received")
    public Long bytesReceived() {
        return this.bytesReceived;
    }

    public T bytesReceived(Long value) {
        Long oldValue = this.bytesReceived;
        this.bytesReceived = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bytesReceived", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="bytes-sent")
    public Long bytesSent() {
        return this.bytesSent;
    }

    public T bytesSent(Long value) {
        Long oldValue = this.bytesSent;
        this.bytesSent = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bytesSent", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="decode-url")
    public Boolean decodeUrl() {
        return this.decodeUrl;
    }

    public T decodeUrl(Boolean value) {
        Boolean oldValue = this.decodeUrl;
        this.decodeUrl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("decodeUrl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disallowed-methods")
    public List<String> disallowedMethods() {
        return this.disallowedMethods;
    }

    public T disallowedMethods(List<String> value) {
        List<String> oldValue = this.disallowedMethods;
        this.disallowedMethods = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("disallowedMethods", oldValue, value);
        }
        return (T)this;
    }

    public T disallowedMethod(String value) {
        if (this.disallowedMethods == null) {
            this.disallowedMethods = new ArrayList<String>();
        }
        this.disallowedMethods.add(value);
        return (T)this;
    }

    public T disallowedMethods(String ... args) {
        this.disallowedMethods(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="error-count")
    public Long errorCount() {
        return this.errorCount;
    }

    public T errorCount(Long value) {
        Long oldValue = this.errorCount;
        this.errorCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("errorCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-ajp-packet-size")
    public Integer maxAjpPacketSize() {
        return this.maxAjpPacketSize;
    }

    public T maxAjpPacketSize(Integer value) {
        Integer oldValue = this.maxAjpPacketSize;
        this.maxAjpPacketSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxAjpPacketSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-buffered-request-size")
    public Integer maxBufferedRequestSize() {
        return this.maxBufferedRequestSize;
    }

    public T maxBufferedRequestSize(Integer value) {
        Integer oldValue = this.maxBufferedRequestSize;
        this.maxBufferedRequestSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxBufferedRequestSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-connections")
    public Integer maxConnections() {
        return this.maxConnections;
    }

    public T maxConnections(Integer value) {
        Integer oldValue = this.maxConnections;
        this.maxConnections = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxConnections", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-cookies")
    public Integer maxCookies() {
        return this.maxCookies;
    }

    public T maxCookies(Integer value) {
        Integer oldValue = this.maxCookies;
        this.maxCookies = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxCookies", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-header-size")
    public Integer maxHeaderSize() {
        return this.maxHeaderSize;
    }

    public T maxHeaderSize(Integer value) {
        Integer oldValue = this.maxHeaderSize;
        this.maxHeaderSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxHeaderSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-headers")
    public Integer maxHeaders() {
        return this.maxHeaders;
    }

    public T maxHeaders(Integer value) {
        Integer oldValue = this.maxHeaders;
        this.maxHeaders = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxHeaders", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-parameters")
    public Integer maxParameters() {
        return this.maxParameters;
    }

    public T maxParameters(Integer value) {
        Integer oldValue = this.maxParameters;
        this.maxParameters = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxParameters", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-post-size")
    public Long maxPostSize() {
        return this.maxPostSize;
    }

    public T maxPostSize(Long value) {
        Long oldValue = this.maxPostSize;
        this.maxPostSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPostSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-processing-time")
    public Long maxProcessingTime() {
        return this.maxProcessingTime;
    }

    public T maxProcessingTime(Long value) {
        Long oldValue = this.maxProcessingTime;
        this.maxProcessingTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxProcessingTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="no-request-timeout")
    public Integer noRequestTimeout() {
        return this.noRequestTimeout;
    }

    public T noRequestTimeout(Integer value) {
        Integer oldValue = this.noRequestTimeout;
        this.noRequestTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("noRequestTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="processing-time")
    public Long processingTime() {
        return this.processingTime;
    }

    public T processingTime(Long value) {
        Long oldValue = this.processingTime;
        this.processingTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("processingTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="read-timeout")
    public Integer readTimeout() {
        return this.readTimeout;
    }

    public T readTimeout(Integer value) {
        Integer oldValue = this.readTimeout;
        this.readTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("readTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="receive-buffer")
    public Integer receiveBuffer() {
        return this.receiveBuffer;
    }

    public T receiveBuffer(Integer value) {
        Integer oldValue = this.receiveBuffer;
        this.receiveBuffer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("receiveBuffer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="record-request-start-time")
    public Boolean recordRequestStartTime() {
        return this.recordRequestStartTime;
    }

    public T recordRequestStartTime(Boolean value) {
        Boolean oldValue = this.recordRequestStartTime;
        this.recordRequestStartTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recordRequestStartTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="redirect-socket")
    public String redirectSocket() {
        return this.redirectSocket;
    }

    public T redirectSocket(String value) {
        String oldValue = this.redirectSocket;
        this.redirectSocket = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("redirectSocket", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-count")
    public Long requestCount() {
        return this.requestCount;
    }

    public T requestCount(Long value) {
        Long oldValue = this.requestCount;
        this.requestCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-parse-timeout")
    public Integer requestParseTimeout() {
        return this.requestParseTimeout;
    }

    public T requestParseTimeout(Integer value) {
        Integer oldValue = this.requestParseTimeout;
        this.requestParseTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestParseTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="resolve-peer-address")
    public Boolean resolvePeerAddress() {
        return this.resolvePeerAddress;
    }

    public T resolvePeerAddress(Boolean value) {
        Boolean oldValue = this.resolvePeerAddress;
        this.resolvePeerAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("resolvePeerAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="rfc6265-cookie-validation")
    public Boolean rfc6265CookieValidation() {
        return this.rfc6265CookieValidation;
    }

    public T rfc6265CookieValidation(Boolean value) {
        Boolean oldValue = this.rfc6265CookieValidation;
        this.rfc6265CookieValidation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("rfc6265CookieValidation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scheme")
    public String scheme() {
        return this.scheme;
    }

    public T scheme(String value) {
        String oldValue = this.scheme;
        this.scheme = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scheme", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="secure")
    public Boolean secure() {
        return this.secure;
    }

    public T secure(Boolean value) {
        Boolean oldValue = this.secure;
        this.secure = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("secure", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="send-buffer")
    public Integer sendBuffer() {
        return this.sendBuffer;
    }

    public T sendBuffer(Integer value) {
        Integer oldValue = this.sendBuffer;
        this.sendBuffer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sendBuffer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tcp-backlog")
    public Integer tcpBacklog() {
        return this.tcpBacklog;
    }

    public T tcpBacklog(Integer value) {
        Integer oldValue = this.tcpBacklog;
        this.tcpBacklog = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tcpBacklog", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tcp-keep-alive")
    public Boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public T tcpKeepAlive(Boolean value) {
        Boolean oldValue = this.tcpKeepAlive;
        this.tcpKeepAlive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tcpKeepAlive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url-charset")
    public String urlCharset() {
        return this.urlCharset;
    }

    public T urlCharset(String value) {
        String oldValue = this.urlCharset;
        this.urlCharset = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("urlCharset", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker")
    public String worker() {
        return this.worker;
    }

    public T worker(String value) {
        String oldValue = this.worker;
        this.worker = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("worker", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="write-timeout")
    public Integer writeTimeout() {
        return this.writeTimeout;
    }

    public T writeTimeout(Integer value) {
        Integer oldValue = this.writeTimeout;
        this.writeTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("writeTimeout", oldValue, value);
        }
        return (T)this;
    }
}

