/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.transactions.log_store;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.transactions.log_store.transactions.Participants;
import org.wildfly.swarm.config.transactions.log_store.transactions.ParticipantsConsumer;
import org.wildfly.swarm.config.transactions.log_store.transactions.ParticipantsSupplier;

@Address(value="/subsystem=transactions/log-store=log-store/transactions=*")
@ResourceType(value="transactions")
public class Transactions<T extends Transactions<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private TransactionsResources subresources = new TransactionsResources();
    @AttributeDocumentation(value="The time since this transaction was prepared or when the recovery system last tried to recover it.")
    private Long ageInSeconds;
    @AttributeDocumentation(value="The id of this transaction.")
    private String id;
    @AttributeDocumentation(value="The JMX name of this transaction.")
    private String jmxName;
    @AttributeDocumentation(value="The type name under which this record is stored.")
    private String type;

    public Transactions(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public TransactionsResources subresources() {
        return this.subresources;
    }

    public T participants(List<Participants> value) {
        this.subresources.participants = value;
        return (T)this;
    }

    public T participants(Participants value) {
        this.subresources.participants.add(value);
        return (T)this;
    }

    public T participants(String childKey, ParticipantsConsumer consumer) {
        Participants child = new Participants(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.participants(child);
        return (T)this;
    }

    public T participants(String childKey) {
        this.participants(childKey, null);
        return (T)this;
    }

    public T participants(ParticipantsSupplier supplier) {
        this.participants(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="age-in-seconds")
    public Long ageInSeconds() {
        return this.ageInSeconds;
    }

    public T ageInSeconds(Long value) {
        Long oldValue = this.ageInSeconds;
        this.ageInSeconds = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ageInSeconds", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="id")
    public String id() {
        return this.id;
    }

    public T id(String value) {
        String oldValue = this.id;
        this.id = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("id", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jmx-name")
    public String jmxName() {
        return this.jmxName;
    }

    public T jmxName(String value) {
        String oldValue = this.jmxName;
        this.jmxName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jmxName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }

    public static class TransactionsResources {
        @ResourceDocumentation(value="The resources that did work in a transaction.")
        @SubresourceInfo(value="participants")
        private List<Participants> participants = new ArrayList<Participants>();

        @Subresource
        public List<Participants> participants() {
            return this.participants;
        }

        public Participants participants(String key) {
            return this.participants.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

