/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=modcluster/mod-cluster-config=configuration/dynamic-load-provider=configuration/load-metric=*")
@ResourceType(value="load-metric")
public class LoadMetric<T extends LoadMetric<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Capacity of the metric.")
    private Double capacity;
    @AttributeDocumentation(value="Properties for the metric.")
    private Map property;
    @AttributeDocumentation(value="Type of the metric")
    private Type type;
    @AttributeDocumentation(value="Weight of the metric.")
    private Integer weight;

    public LoadMetric(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="capacity")
    public Double capacity() {
        return this.capacity;
    }

    public T capacity(Double value) {
        Double oldValue = this.capacity;
        this.capacity = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacity", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="property")
    public Map property() {
        return this.property;
    }

    public T property(Map value) {
        Map oldValue = this.property;
        this.property = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("property", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.property == null) {
            this.property = new HashMap();
        }
        this.property.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public Type type() {
        return this.type;
    }

    public T type(Type value) {
        Type oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="weight")
    public Integer weight() {
        return this.weight;
    }

    public T weight(Integer value) {
        Integer oldValue = this.weight;
        this.weight = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("weight", oldValue, value);
        }
        return (T)this;
    }

    public static enum Type {
        CPU("cpu"),
        MEM("mem"),
        HEAP("heap"),
        SESSIONS("sessions"),
        RECEIVE_TRAFFIC("receive-traffic"),
        SEND_TRAFFIC("send-traffic"),
        REQUESTS("requests"),
        BUSYNESS("busyness");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Type(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

