/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/jms-topic=*")
@ResourceType(value="jms-topic")
public class JMSTopic<T extends JMSTopic<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The number of messages that this queue is currently delivering to its consumers.")
    private Integer deliveringCount;
    @AttributeDocumentation(value="The number of messages for all durable subscribers for this topic.")
    private Integer durableMessageCount;
    @AttributeDocumentation(value="The number of durable subscribers for this topic.")
    private Integer durableSubscriptionCount;
    @AttributeDocumentation(value="The jndi names the topic will be bound to.")
    private List<String> entries;
    @AttributeDocumentation(value="The legacy jndi names the topic will be bound to.")
    private List<String> legacyEntries;
    @AttributeDocumentation(value="The number of messages currently in this queue.")
    private Long messageCount;
    @AttributeDocumentation(value="The number of messages added to this queue since it was created.")
    private Long messagesAdded;
    @AttributeDocumentation(value="The number of messages for all non-durable subscribers for this topic.")
    private Integer nonDurableMessageCount;
    @AttributeDocumentation(value="The number of non-durable subscribers for this topic.")
    private Integer nonDurableSubscriptionCount;
    @AttributeDocumentation(value="The number of (durable and non-durable) subscribers for this topic.")
    private Integer subscriptionCount;
    @AttributeDocumentation(value="Whether the topic is temporary.")
    private Boolean temporary;
    @AttributeDocumentation(value="The address the topic points to.")
    private String topicAddress;

    public JMSTopic(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="delivering-count")
    public Integer deliveringCount() {
        return this.deliveringCount;
    }

    public T deliveringCount(Integer value) {
        Integer oldValue = this.deliveringCount;
        this.deliveringCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deliveringCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="durable-message-count")
    public Integer durableMessageCount() {
        return this.durableMessageCount;
    }

    public T durableMessageCount(Integer value) {
        Integer oldValue = this.durableMessageCount;
        this.durableMessageCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("durableMessageCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="durable-subscription-count")
    public Integer durableSubscriptionCount() {
        return this.durableSubscriptionCount;
    }

    public T durableSubscriptionCount(Integer value) {
        Integer oldValue = this.durableSubscriptionCount;
        this.durableSubscriptionCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("durableSubscriptionCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="entries")
    public List<String> entries() {
        return this.entries;
    }

    public T entries(List<String> value) {
        List<String> oldValue = this.entries;
        this.entries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("entries", oldValue, value);
        }
        return (T)this;
    }

    public T entry(String value) {
        if (this.entries == null) {
            this.entries = new ArrayList<String>();
        }
        this.entries.add(value);
        return (T)this;
    }

    public T entries(String ... args) {
        this.entries(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="legacy-entries")
    public List<String> legacyEntries() {
        return this.legacyEntries;
    }

    public T legacyEntries(List<String> value) {
        List<String> oldValue = this.legacyEntries;
        this.legacyEntries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("legacyEntries", oldValue, value);
        }
        return (T)this;
    }

    public T legacyEntry(String value) {
        if (this.legacyEntries == null) {
            this.legacyEntries = new ArrayList<String>();
        }
        this.legacyEntries.add(value);
        return (T)this;
    }

    public T legacyEntries(String ... args) {
        this.legacyEntries(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-count")
    public Long messageCount() {
        return this.messageCount;
    }

    public T messageCount(Long value) {
        Long oldValue = this.messageCount;
        this.messageCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="messages-added")
    public Long messagesAdded() {
        return this.messagesAdded;
    }

    public T messagesAdded(Long value) {
        Long oldValue = this.messagesAdded;
        this.messagesAdded = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messagesAdded", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="non-durable-message-count")
    public Integer nonDurableMessageCount() {
        return this.nonDurableMessageCount;
    }

    public T nonDurableMessageCount(Integer value) {
        Integer oldValue = this.nonDurableMessageCount;
        this.nonDurableMessageCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nonDurableMessageCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="non-durable-subscription-count")
    public Integer nonDurableSubscriptionCount() {
        return this.nonDurableSubscriptionCount;
    }

    public T nonDurableSubscriptionCount(Integer value) {
        Integer oldValue = this.nonDurableSubscriptionCount;
        this.nonDurableSubscriptionCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nonDurableSubscriptionCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="subscription-count")
    public Integer subscriptionCount() {
        return this.subscriptionCount;
    }

    public T subscriptionCount(Integer value) {
        Integer oldValue = this.subscriptionCount;
        this.subscriptionCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("subscriptionCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="temporary")
    public Boolean temporary() {
        return this.temporary;
    }

    public T temporary(Boolean value) {
        Boolean oldValue = this.temporary;
        this.temporary = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("temporary", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="topic-address")
    public String topicAddress() {
        return this.topicAddress;
    }

    public T topicAddress(String value) {
        String oldValue = this.topicAddress;
        this.topicAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("topicAddress", oldValue, value);
        }
        return (T)this;
    }
}

