/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.io.worker;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=io/worker=*/outbound-bind-address=*")
@ResourceType(value="outbound-bind-address")
public class OutboundBindAddress<T extends OutboundBindAddress<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The address to bind to when the destination address matches")
    private String bindAddress;
    @AttributeDocumentation(value="The port number to bind to when the destination address matches")
    private Integer bindPort;
    @AttributeDocumentation(value="The destination address range to match")
    private String match;

    public OutboundBindAddress(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="bind-address")
    public String bindAddress() {
        return this.bindAddress;
    }

    public T bindAddress(String value) {
        String oldValue = this.bindAddress;
        this.bindAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bindAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="bind-port")
    public Integer bindPort() {
        return this.bindPort;
    }

    public T bindPort(Integer value) {
        Integer oldValue = this.bindPort;
        this.bindPort = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bindPort", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="match")
    public String match() {
        return this.match;
    }

    public T match(String value) {
        String oldValue = this.match;
        this.match = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("match", oldValue, value);
        }
        return (T)this;
    }
}

