/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=binary-jdbc/table=binary", "/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=mixed-jdbc/table=binary", "/subsystem=infinispan/cache-container=*/local-cache=*/store=binary-jdbc/table=binary", "/subsystem=infinispan/cache-container=*/local-cache=*/store=mixed-jdbc/table=binary", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=binary-jdbc/table=binary", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=mixed-jdbc/table=binary", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=binary-jdbc/table=binary", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=mixed-jdbc/table=binary"})
@ResourceType(value="table")
@Implicit
public class BinaryTable<T extends BinaryTable<T>>
implements Keyed {
    private String key = "binary";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="For DB inserts, the batch size determines how many inserts are batched together.")
    private Integer batchSize;
    @AttributeDocumentation(value="A database column to hold cache entry data.")
    private Map dataColumn;
    @AttributeDocumentation(value="For DB queries, the fetch size will be used to set the fetch size on ResultSets.")
    private Integer fetchSize;
    @AttributeDocumentation(value="A database column to hold cache entry ids.")
    private Map idColumn;
    @AttributeDocumentation(value="The prefix for the database table name.")
    private String prefix;
    @AttributeDocumentation(value="A database column to hold cache entry timestamps.")
    private Map timestampColumn;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="batch-size")
    public Integer batchSize() {
        return this.batchSize;
    }

    public T batchSize(Integer value) {
        Integer oldValue = this.batchSize;
        this.batchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("batchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="data-column")
    public Map dataColumn() {
        return this.dataColumn;
    }

    public T dataColumn(Map value) {
        Map oldValue = this.dataColumn;
        this.dataColumn = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dataColumn", oldValue, value);
        }
        return (T)this;
    }

    public T dataColumn(String key, Object value) {
        if (this.dataColumn == null) {
            this.dataColumn = new HashMap();
        }
        this.dataColumn.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="fetch-size")
    public Integer fetchSize() {
        return this.fetchSize;
    }

    public T fetchSize(Integer value) {
        Integer oldValue = this.fetchSize;
        this.fetchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("fetchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="id-column")
    public Map idColumn() {
        return this.idColumn;
    }

    public T idColumn(Map value) {
        Map oldValue = this.idColumn;
        this.idColumn = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("idColumn", oldValue, value);
        }
        return (T)this;
    }

    public T idColumn(String key, Object value) {
        if (this.idColumn == null) {
            this.idColumn = new HashMap();
        }
        this.idColumn.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="prefix")
    public String prefix() {
        return this.prefix;
    }

    public T prefix(String value) {
        String oldValue = this.prefix;
        this.prefix = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("prefix", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="timestamp-column")
    public Map timestampColumn() {
        return this.timestampColumn;
    }

    public T timestampColumn(Map value) {
        Map oldValue = this.timestampColumn;
        this.timestampColumn = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timestampColumn", oldValue, value);
        }
        return (T)this;
    }

    public T timestampColumn(String key, Object value) {
        if (this.timestampColumn == null) {
            this.timestampColumn = new HashMap();
        }
        this.timestampColumn.put(key, value);
        return (T)this;
    }
}

