/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=backups/backup=*", "/subsystem=infinispan/cache-container=*/distributed-cache=*/component=backups/backup=*"})
@ResourceType(value="backup")
public class Backup<T extends Backup<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Indicates the number of failures after which this backup site should go offline.")
    private Integer afterFailures;
    @AttributeDocumentation(value="Indicates whether or not this backup site is enabled.")
    private Boolean enabled;
    @AttributeDocumentation(value="The policy to follow when connectivity to the backup site fails.")
    private FailurePolicy failurePolicy;
    @AttributeDocumentation(value="Indicates the minimum time (in milliseconds) to wait after the max number of failures is reached, after which this backup site should go offline.")
    private Long minWait;
    @AttributeDocumentation(value="The backup strategy for this cache")
    private Strategy strategy;
    @AttributeDocumentation(value="The timeout for replicating to the backup site.")
    private Long timeout;

    public Backup(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="after-failures")
    public Integer afterFailures() {
        return this.afterFailures;
    }

    public T afterFailures(Integer value) {
        Integer oldValue = this.afterFailures;
        this.afterFailures = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("afterFailures", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="failure-policy")
    public FailurePolicy failurePolicy() {
        return this.failurePolicy;
    }

    public T failurePolicy(FailurePolicy value) {
        FailurePolicy oldValue = this.failurePolicy;
        this.failurePolicy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("failurePolicy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-wait")
    public Long minWait() {
        return this.minWait;
    }

    public T minWait(Long value) {
        Long oldValue = this.minWait;
        this.minWait = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minWait", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="strategy")
    public Strategy strategy() {
        return this.strategy;
    }

    public T strategy(Strategy value) {
        Strategy oldValue = this.strategy;
        this.strategy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("strategy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="timeout")
    public Long timeout() {
        return this.timeout;
    }

    public T timeout(Long value) {
        Long oldValue = this.timeout;
        this.timeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeout", oldValue, value);
        }
        return (T)this;
    }

    public static enum Strategy {
        SYNC("SYNC"),
        ASYNC("ASYNC");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Strategy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum FailurePolicy {
        IGNORE("IGNORE"),
        WARN("WARN"),
        FAIL("FAIL"),
        CUSTOM("CUSTOM");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private FailurePolicy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

