/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/identity-realm=*")
@ResourceType(value="identity-realm")
public class IdentityRealm<T extends IdentityRealm<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the attribute associated with this identity.")
    private String attributeName;
    @AttributeDocumentation(value="The values associated with the identities attribute.")
    private List<String> attributeValues;
    @AttributeDocumentation(value="The identity available from the security realm.")
    private String identity;

    public IdentityRealm(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="attribute-name")
    public String attributeName() {
        return this.attributeName;
    }

    public T attributeName(String value) {
        String oldValue = this.attributeName;
        this.attributeName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="attribute-values")
    public List<String> attributeValues() {
        return this.attributeValues;
    }

    public T attributeValues(List<String> value) {
        List<String> oldValue = this.attributeValues;
        this.attributeValues = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeValues", oldValue, value);
        }
        return (T)this;
    }

    public T attributeValue(String value) {
        if (this.attributeValues == null) {
            this.attributeValues = new ArrayList<String>();
        }
        this.attributeValues.add(value);
        return (T)this;
    }

    public T attributeValues(String ... args) {
        this.attributeValues(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="identity")
    public String identity() {
        return this.identity;
    }

    public T identity(String value) {
        String oldValue = this.identity;
        this.identity = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("identity", oldValue, value);
        }
        return (T)this;
    }
}

