/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/constant-role-mapper=*")
@ResourceType(value="constant-role-mapper")
public class ConstantRoleMapper<T extends ConstantRoleMapper<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The constant roles to be returned by this role mapper.")
    private List<String> roles;

    public ConstantRoleMapper(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="roles")
    public List<String> roles() {
        return this.roles;
    }

    public T roles(List<String> value) {
        List<String> oldValue = this.roles;
        this.roles = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("roles", oldValue, value);
        }
        return (T)this;
    }

    public T role(String value) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(value);
        return (T)this;
    }

    public T roles(String ... args) {
        this.roles(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

